<?php
require_once __DIR__ . '/user_order_utils.php';

// بروزرسانی کش محصولات
$all_products = getProductsFromApi();
$products = [];
foreach($all_products as $p) {
    if((isset($p["status"]) && $p["status"] !== "publish") || (isset($p["stock_status"]) && $p["stock_status"] !== "instock")) continue;
    if(isset($p["type"]) && !in_array($p["type"], ["simple", "variable"])) continue;
    // اگر محصول variable است، باید حداقل یک متغیر فعال داشته باشد
    if(isset($p["type"]) && $p["type"] == "variable") {
        $vars = getProductVariationsFromApi($p["id"]);
        if(!is_array($vars) || count($vars) == 0) continue;
    }
    $products[] = $p;
}

// ذخیره فایل در مسیر مشخص
file_put_contents(__DIR__ . '/products_cache.json', json_encode($products, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
echo "Products cache updated.\n";

// بروزرسانی کش متغیرهای هر محصول قابل خرید
foreach($products as $p) {
    $vars = getProductVariationsFromApi($p['id']);
    echo "Product ID {$p['id']} variations cache updated.\n";
}

// ثبت لاگ کامل محصولات و متغیرها (فقط محصولات قابل خرید)
logAllProductsAndVariations();
echo "Products and variations log updated.\n";
