<?php
// توابع مدیریت محصولات و آموزش‌ها
require_once __DIR__ . '/../conf/config.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/message_utils.php';
require_once __DIR__ . '/user_order_utils.php';

function adminDeleteProductMessage($chat_id, $product_id, $msg_number) {
    $stmt = dbQuery("SELECT id FROM product_messages WHERE product_id = ? ORDER BY step_number ASC", [$product_id]);
    $messages = $stmt->fetchAll();
    if(!isset($messages[$msg_number-1])) { sendMessage($chat_id, 'شماره پیام معتبر نیست.'); return; }
    $msg_id = $messages[$msg_number-1]['id'];
    dbQuery("DELETE FROM product_messages WHERE id = ?", [$msg_id]);
    $stmt2 = dbQuery("SELECT id FROM product_messages WHERE product_id = ? ORDER BY step_number ASC", [$product_id]);
    $all = $stmt2->fetchAll();
    foreach($all as $i => $row) dbQuery("UPDATE product_messages SET step_number = ? WHERE id = ?", [$i+1, $row['id']]);
    sendMessage($chat_id, 'پیام مورد نظر حذف شد.');
    adminShowProductMessages($chat_id, $product_id);
}
function adminEditProductMessage($chat_id, $product_id, $msg_number) {
    $stmt = dbQuery("SELECT id FROM product_messages WHERE product_id = ? ORDER BY step_number ASC", [$product_id]);
    $messages = $stmt->fetchAll();
    if(!isset($messages[$msg_number-1])) { sendMessage($chat_id, 'شماره پیام معتبر نیست.'); return; }
    $msg_id = $messages[$msg_number-1]['id'];
    file_put_contents("admin_editmsg_{$chat_id}.tmp", json_encode(['product_id'=>$product_id,'msg_id'=>$msg_id]));
    sendMessage($chat_id, 'پیام جدید (متن، عکس، ویدیو، ویس یا فوروارد) را برای جایگزینی ارسال کنید:', ["force_reply" => true]);
}
function adminProductTrainingsMenu($chat_id, $message_id = null) {
    $products = getProductsFromApi();
    $text = '📦 یک محصول را برای مدیریت آموزش انتخاب کنید:\n';
    foreach($products as $i => $p) {
        $text .= ($i+1) . ". {$p['name']}\n";
    }
    $text .= "\nبرای انتخاب محصول، شماره ردیف را ارسال کنید یا 'بازگشت' را بزنید.";
    $reply_keyboard = [
        'keyboard' => [
            [['text' => 'بازگشت']],
        ],
        'resize_keyboard' => true,
        'one_time_keyboard' => false
    ];
    if($message_id)
        editMessage($chat_id, $message_id, $text, $reply_keyboard);
    else
        sendMessage($chat_id, $text, $reply_keyboard);
}
function adminShowProductMessages($chat_id, $product_id, $message_id = null, $mode = null) {
    $stmt = dbQuery("SELECT * FROM product_messages WHERE product_id = ? ORDER BY step_number ASC", [$product_id]);
    $messages = $stmt->fetchAll();
    $text = "📂 آموزش‌های فعلی برای این محصول:\n";
    $inline_keyboard = [];
    if($messages) {
        foreach($messages as $i => $msg) {
            $short = mb_substr(strip_tags($msg['message_content']),0,20);
            $text .= ($i+1) . ". [{$msg['message_type']}] " . $short . "\n";
            $inline_keyboard[] = [
                ['text' => "👁 مشاهده/ویرایش پیام {$msg['step_number']}", 'callback_data' => "admin_msgview_{$product_id}_{$msg['id']}"]
            ];
        }
    } else {
        $text .= "هیچ پیامی ثبت نشده است.";
    }
    $inline_keyboard[] = [
        ['text' => '➕ افزودن پیام جدید', 'callback_data' => 'admin_addmsg_' . $product_id],
        ['text' => '🗑 حذف همه پیام‌ها', 'callback_data' => 'admin_clear_' . $product_id]
    ];
    $inline_keyboard[] = [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_trainings'] ];
    if($message_id)
        editMessage($chat_id, $message_id, $text, ['inline_keyboard'=>$inline_keyboard]);
    else
        sendMessage($chat_id, $text, ['inline_keyboard'=>$inline_keyboard]);
} 