<?php
// تنظیمات امنیتی - غیرفعال کردن نمایش خطاها در production
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php_error.log');

// تنظیمات امنیتی اضافی
ini_set('expose_php', 0); // مخفی کردن نسخه PHP
ini_set('session.cookie_httponly', 1); // اگر از session استفاده می‌شود
ini_set('session.cookie_secure', 1); // فقط از طریق HTTPS (اگر HTTPS فعال است)
// گزارش خطاها فقط در حالت development
if(defined('DEBUG_MODE') && DEBUG_MODE) {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
}
// لاگ فقط در صورت نیاز (برای کاهش حجم فایل‌های log)
// file_put_contents('very_first_log.txt', date('Y-m-d H:i:s')."\n", FILE_APPEND);
require_once __DIR__ . '/../conf/config.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/message_utils.php';
require_once __DIR__ . '/user_order_utils.php';
require_once __DIR__ . '/product_utils.php';
require_once __DIR__ . '/repeat_purchase_discount_utils.php';

if(!defined('API_URL')) define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');

// دریافت ورودی تلگرام
$content = file_get_contents("php://input");
$update = json_decode($content, true);

// لاگ برای دیباگ
if (empty($update) && !empty($content)) {
    error_log("Telegram Webhook: Failed to decode JSON. Content: " . substr($content, 0, 200));
}

// لاگ برای دیباگ (فقط در صورت نیاز)
if (empty($update)) {
    error_log("Telegram Webhook: Empty or invalid update received. Content length: " . strlen($content));
    // اگر از مرورگر باز شده، پیام نمایش بده
    if (empty($content) && isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'GET') {
        die("This is a Telegram bot webhook endpoint. Access via Telegram only.");
    }
}

// مقداردهی اولیه متغیرها برای جلوگیری از Notice
$data = null;
$is_admin = false;
$text = '';

// غیرفعال کردن لاگ‌های debug در production (فعال کردن فقط در حالت development)
if(defined('DEBUG_MODE') && DEBUG_MODE) {
    file_put_contents('test.txt', date('Y-m-d H:i:s')."\n", FILE_APPEND);
    file_put_contents('update_log.txt', print_r($update, true), FILE_APPEND);
    file_put_contents('step_log.txt', 'step1\n', FILE_APPEND);
}

// بررسی لیست سیاه در ابتدای هر پیام
if(isset($update['message']) && isset($update['message']['chat']['id'])) {
    $user_id = $update['message']['from']['id'];
    $chat_id = $update['message']['chat']['id'];
    
    // بررسی وضعیت شماره موبایل کاربر
    $text_message = $update['message']['text'] ?? '';
    $stmt_mobile = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
    $user_mobile = $stmt_mobile->fetch();
    
    // اگر کاربر شماره موبایل نداشته باشد و پیام غیر از contact و /start باشد
    if((!$user_mobile || !$user_mobile['mobile']) && !isset($update['message']['contact']) && $text_message != '/start' && $text_message != 'بازگشت به منو' && strtolower($text_message) != 'menu') {
        $remind_keyboard = [
            'keyboard' => [
                [ ['text' => '📱 ارسال شماره من', 'request_contact' => true] ]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => true
        ];
        sendMessage($chat_id, "📱 لطفاً شماره موبایل خود را با دکمه زیر ارسال کنید:\n\n⚠️ حتما از دکمه پایین یعنی 'ارسال شماره من' باید شماره خودتون رو ارسال بکنید\n\n❗️ نکته مهم اینکه اگه از داخل سایت سفارشی ثبت کردین باید و حتما همون شماره داخل تلگرام عضو بشین و با همون شماره اقدام بکنید هیچ راه دیگه ای وجود نداره", $remind_keyboard);
        return;
    }
    
    // بررسی لیست سیاه
    $stmt_bl = dbQuery("SELECT until FROM blacklist WHERE telegram_id = ?", [$user_id]);
    if($row_bl = $stmt_bl->fetch()) {
        if(strtotime($row_bl['until']) > time()) {
            sendMessage($update['message']['chat']['id'], "⛔️ دسترسی شما به مدت محدود مسدود شده است. لطفاً بعداً تلاش کنید.");
            return;
        } else {
            dbQuery("DELETE FROM blacklist WHERE telegram_id = ?", [$user_id]);
        }
    }
}

// مدیریت ForceReply برای سفارش و موبایل
if(isset($update['message']) && isset($update['message']['reply_to_message']['text'])) {
    $reply_text = $update['message']['reply_to_message']['text'];
    $chat_id = $update['message']['chat']['id'];
    $user_id = $update['message']['from']['id'];
    $text = $update['message']['text'];
    // جلوگیری از تداخل با حالت‌های ادمین
    // بررسی handlerهای تخفیف خرید مجدد اول (قبل از return)
    if(file_exists("rpd_setpercent_{$user_id}.tmp")) {
        $info = json_decode(@file_get_contents("rpd_setpercent_{$user_id}.tmp"), true);
        @unlink("rpd_setpercent_{$user_id}.tmp");
        if(!$info || !isset($info['product_id']) || !isset($info['variation_id'])) {
            sendMessage($chat_id, 'خطا در دریافت اطلاعات.');
            return;
        }
        $product_id = (int)$info['product_id'];
        $variation_id = (int)$info['variation_id'];
        $percent = intval(trim($text));
        if($percent < 5 || $percent > 60) {
            sendMessage($chat_id, 'درصد تخفیف باید بین 5 تا 60 باشد.');
            return;
        }
        $discount = getRepeatPurchaseDiscount($product_id, $variation_id);
        $is_active = $discount ? $discount['is_active'] : 0;
        $min_purchase = $discount ? $discount['min_purchase_count'] : 1;
        $min_days = $discount ? $discount['min_days_since_last_purchase'] : 0;
        $custom_msg = $discount ? $discount['custom_message'] : '';
        saveRepeatPurchaseDiscount($product_id, $variation_id, $percent, $is_active, $min_purchase, $min_days, $custom_msg);
        sendMessage($chat_id, "درصد تخفیف {$percent}% با موفقیت تنظیم شد.");
        showRepeatPurchaseDiscountSettings($chat_id, $product_id, $variation_id);
        return;
    }
    if(file_exists("rpd_setminpurchase_{$user_id}.tmp")) {
        $info = json_decode(@file_get_contents("rpd_setminpurchase_{$user_id}.tmp"), true);
        @unlink("rpd_setminpurchase_{$user_id}.tmp");
        if(!$info || !isset($info['product_id']) || !isset($info['variation_id'])) {
            sendMessage($chat_id, 'خطا در دریافت اطلاعات.');
            return;
        }
        $product_id = (int)$info['product_id'];
        $variation_id = (int)$info['variation_id'];
        $min_purchase = intval(trim($text));
        if($min_purchase < 1) {
            sendMessage($chat_id, 'حداقل تعداد خرید باید 1 یا بیشتر باشد.');
            return;
        }
        $discount = getRepeatPurchaseDiscount($product_id, $variation_id);
        $percent = $discount ? $discount['discount_percent'] : 0;
        $is_active = $discount ? $discount['is_active'] : 0;
        $min_days = $discount ? $discount['min_days_since_last_purchase'] : 0;
        $custom_msg = $discount ? $discount['custom_message'] : '';
        saveRepeatPurchaseDiscount($product_id, $variation_id, $percent, $is_active, $min_purchase, $min_days, $custom_msg);
        sendMessage($chat_id, "حداقل تعداد خرید {$min_purchase} با موفقیت تنظیم شد.");
        showRepeatPurchaseDiscountSettings($chat_id, $product_id, $variation_id);
        return;
    }
    if(file_exists("rpd_setmindays_{$user_id}.tmp")) {
        $info = json_decode(@file_get_contents("rpd_setmindays_{$user_id}.tmp"), true);
        @unlink("rpd_setmindays_{$user_id}.tmp");
        if(!$info || !isset($info['product_id']) || !isset($info['variation_id'])) {
            sendMessage($chat_id, 'خطا در دریافت اطلاعات.');
            return;
        }
        $product_id = (int)$info['product_id'];
        $variation_id = (int)$info['variation_id'];
        $min_days = intval(trim($text));
        if($min_days < 0) {
            sendMessage($chat_id, 'حداقل روز باید 0 یا بیشتر باشد (0 یعنی بدون محدودیت).');
            return;
        }
        $discount = getRepeatPurchaseDiscount($product_id, $variation_id);
        $percent = $discount ? $discount['discount_percent'] : 0;
        $is_active = $discount ? $discount['is_active'] : 0;
        $min_purchase = $discount ? $discount['min_purchase_count'] : 1;
        $custom_msg = $discount ? $discount['custom_message'] : '';
        saveRepeatPurchaseDiscount($product_id, $variation_id, $percent, $is_active, $min_purchase, $min_days, $custom_msg);
        if($min_days == 0) {
            sendMessage($chat_id, "محدودیت روز حذف شد (بدون محدودیت).");
        } else {
            sendMessage($chat_id, "حداقل {$min_days} روز از آخرین خرید با موفقیت تنظیم شد.");
        }
        showRepeatPurchaseDiscountSettings($chat_id, $product_id, $variation_id);
        return;
    }
    if(file_exists("rpd_setmessage_{$user_id}.tmp")) {
        $info = json_decode(@file_get_contents("rpd_setmessage_{$user_id}.tmp"), true);
        @unlink("rpd_setmessage_{$user_id}.tmp");
        if(!$info || !isset($info['product_id']) || !isset($info['variation_id'])) {
            sendMessage($chat_id, 'خطا در دریافت اطلاعات.');
            return;
        }
        $product_id = (int)$info['product_id'];
        $variation_id = (int)$info['variation_id'];
        $custom_msg = trim($text);
        $discount = getRepeatPurchaseDiscount($product_id, $variation_id);
        $percent = $discount ? $discount['discount_percent'] : 0;
        $is_active = $discount ? $discount['is_active'] : 0;
        $min_purchase = $discount ? $discount['min_purchase_count'] : 1;
        $min_days = $discount ? $discount['min_days_since_last_purchase'] : 0;
        saveRepeatPurchaseDiscount($product_id, $variation_id, $percent, $is_active, $min_purchase, $min_days, $custom_msg);
        sendMessage($chat_id, "پیام سفارشی با موفقیت تنظیم شد.");
        showRepeatPurchaseDiscountSettings($chat_id, $product_id, $variation_id);
        return;
    }
    
    if(file_exists("admin_addmsg_{$user_id}.tmp") || file_exists("admin_delmsg_{$chat_id}.tmp") || file_exists("admin_editmsg_{$chat_id}.tmp") || file_exists("admin_usermsg_{$chat_id}.tmp") || file_exists("admin_usercoupon_{$chat_id}.tmp") || file_exists("admin_userban_{$chat_id}.tmp") || file_exists("admin_searchuser_{$chat_id}.tmp") || file_exists("admin_editcoupon_{$chat_id}.tmp") || file_exists("admin_editmsgdo_{$chat_id}.tmp") || file_exists("admin_ordernote_{$chat_id}.tmp")) {
        // اگر هیچکدام از فایل‌های ForceReply مربوط به سفارش نبود، ادامه نده
        // ForceReply سفارش فقط اگر هیچکدام از فایل‌های بالا نبود اجرا شود
        return;
    }
    if(strpos($reply_text, 'شماره سفارش') !== false) {
        setTempOrderId($user_id, $text);
        sendMessage($chat_id, 'حالا شماره موبایلی که موقع خرید وارد کردید رو بفرستید 📱', ["force_reply" => true]);
        return;
    } elseif(strpos($reply_text, 'موبایلی که موقع خرید وارد کردید') !== false) {
        $order_id = getTempOrderId($user_id);
        if($order_id) sendProductTraining($chat_id, $order_id, $text);
        return;
    } else sendMessage($chat_id, 'خطا در دریافت شماره سفارش. لطفاً مجدداً تلاش کنید.');
    $count = increaseUserError($user_id);
    if($count >= 5) {
        $until = date('Y-m-d H:i:s', time() + 2*60*60);
        dbQuery("INSERT INTO blacklist (telegram_id, until) VALUES (?, ?) ON DUPLICATE KEY UPDATE until = ?", [$user_id, $until, $until]);
        sendMessage($chat_id, "⛔️ به دلیل ورود اطلاعات اشتباه، دسترسی شما به مدت ۲ ساعت مسدود شد.");
        // اطلاع به همه ادمین‌ها
        $stmt_admins = dbQuery("SELECT telegram_id FROM admins");
        while($admin = $stmt_admins->fetch()) {
            sendMessage($admin['telegram_id'], "کاربر با آیدی {$user_id} به دلیل ورود اطلاعات اشتباه به مدت ۲ ساعت بن شد.");
        }
        return;
    }
    resetUserError($user_id);
    if(file_exists("admin_addadmin_{$chat_id}.tmp")) {
        @unlink("admin_addadmin_{$chat_id}.tmp");
        // اعتبارسنجی ورودی - فقط عدد مجاز است
        $admin_id = preg_replace('/[^0-9]/', '', $text);
        if(empty($admin_id) || strlen($admin_id) > 20) {
            sendMessage($chat_id, 'آیدی ادمین معتبر نیست.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        dbQuery("INSERT IGNORE INTO admins (telegram_id) VALUES (?)", [$admin_id]);
        sendMessage($chat_id, 'ادمین جدید با موفقیت اضافه شد.');
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    }
    if(file_exists("admin_deladmin_{$chat_id}.tmp")) {
        @unlink("admin_deladmin_{$chat_id}.tmp");
        // اعتبارسنجی ورودی - فقط عدد مجاز است
        $admin_id = preg_replace('/[^0-9]/', '', $text);
        if(empty($admin_id) || strlen($admin_id) > 20) {
            sendMessage($chat_id, 'آیدی ادمین معتبر نیست.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        dbQuery("DELETE FROM admins WHERE telegram_id = ? AND telegram_id != ?", [$admin_id, ADMIN_ID]);
        sendMessage($chat_id, 'ادمین مورد نظر حذف شد.');
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    }
    if(file_exists("admin_ordernote_{$chat_id}.tmp")) {
        $info = json_decode(@file_get_contents("admin_ordernote_{$chat_id}.tmp"), true);
        @unlink("admin_ordernote_{$chat_id}.tmp");
        $order_id = $info['order_id'];
        $is_user = $info['is_user'];
        $note = $text;
        $url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}/notes?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
        $payload = json_encode([
            'note' => $note,
            'customer_note' => $is_user
        ]);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length' => strlen($payload)
        ]);
        $result = curl_exec($ch);
        curl_close($ch);
        sendMessage($chat_id, 'یادداشت با موفقیت ثبت شد.');
        // اگر یادداشت برای کاربر بود، به کاربر تلگرام هم ارسال شود
        if($is_user) {
            $order = getOrderFromApi($order_id);
            $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
            if($order_mobile && strlen($order_mobile) === 11 && strpos($order_mobile, '09') === 0) {
                $stmt = dbQuery("SELECT telegram_id FROM users WHERE mobile = ?", [$order_mobile]);
                if($row = $stmt->fetch()) {
                    sendMessage($row['telegram_id'], "یادداشت جدید برای سفارش شما (#{$order_id}):\n" . $note);
                }
            }
        }
    }
    // ارسال پیام شخصی به کاربر
    if(file_exists("admin_usermsg_{$chat_id}.tmp")) {
        $target_id = @file_get_contents("admin_usermsg_{$chat_id}.tmp");
        @unlink("admin_usermsg_{$chat_id}.tmp");
        sendMessage($target_id, "📩 پیام از مدیر:\n".$text);
        sendMessage($chat_id, 'پیام شما با موفقیت برای کاربر ارسال شد.');
        logAdminAction($user_id, 'send_private_message', $target_id, mb_substr($text,0,100));
        return;
    }
    // ویرایش کد تخفیف اختصاصی
    if(file_exists("admin_editcoupon_{$chat_id}.tmp")) {
        $info = json_decode(@file_get_contents("admin_editcoupon_{$chat_id}.tmp"), true);
        @unlink("admin_editcoupon_{$chat_id}.tmp");
        if(!$info || !isset($info['coupon_id']) || !isset($info['user_tg_id'])) {
            sendMessage($chat_id, 'خطا در دریافت اطلاعات.');
            return;
        }
        $coupon_id = (int)$info['coupon_id'];
        $user_tg_id = (int)$info['user_tg_id'];
        $parts = explode(',', $text);
        if(count($parts) != 3) {
            sendMessage($chat_id, 'فرمت ورودی صحیح نیست. مثال: 25,5,2');
            return;
        }
        // اعتبارسنجی ورودی‌ها
        $percent = intval(trim($parts[0]));
        $days = intval(trim($parts[1]));
        $usage = intval(trim($parts[2]));
        // محدودیت‌های منطقی
        if($percent < 1 || $percent > 100) {
            sendMessage($chat_id, 'درصد تخفیف باید بین 1 تا 100 باشد.');
            return;
        }
        if($days < 1 || $days > 365) {
            sendMessage($chat_id, 'تعداد روز باید بین 1 تا 365 باشد.');
            return;
        }
        if($usage < 1 || $usage > 1000) {
            sendMessage($chat_id, 'تعداد دفعات استفاده باید بین 1 تا 1000 باشد.');
            return;
        }
        $expire = date('Y-m-d', strtotime("+{$days} days"));
        $url = "https://goldencheat.ir/wp-json/wc/v3/coupons/{$coupon_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
        $payload = json_encode([
            'amount' => $percent,
            'usage_limit' => $usage,
            'date_expires' => $expire
        ]);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length' => strlen($payload)
        ]);
        $result = curl_exec($ch);
        curl_close($ch);
        logAdminAction($user_id, 'edit_coupon', $user_tg_id, "coupon_id:{$coupon_id}, percent:{$percent}, days:{$days}, usage:{$usage}");
        sendMessage($chat_id, 'کد تخفیف با موفقیت ویرایش شد.');
        // بازگشت به زیرمنوی کاربر
        $data = 'admin_userdetail_'.$user_tg_id;
        // اجرای مجدد زیرمنو
        // ... existing code ...
    }
}

// مدیریت پیام متنی /start و بازگشت به منو و Menu
if(isset($update['message']) && isset($update['message']['text'])) {
    $text = $update['message']['text'];
    $chat_id = $update['message']['chat']['id'];
    $user_id = $update['message']['from']['id'];
    $loading_message_id = sendMessage($chat_id, '⏳ در حال بارگذاری، لطفا صبور باشید...');
    $stmt_admin = dbQuery("SELECT telegram_id FROM admins WHERE telegram_id = ?", [$user_id]);
    $is_admin = ($user_id == ADMIN_ID) || ($stmt_admin->fetch());

    // دکمه بازگشت
    if($text == '🔙 بازگشت') {
        showStartMenu($chat_id, $is_admin);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // دکمه دریافت آموزش من
    if($text == '🎓 دریافت آموزش من') {
        sendMessage($chat_id, 'لطفاً شماره سفارش خود را وارد کنید 🧾', ["force_reply" => true]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // دکمه سفارشات من
    if($text == '📦 سفارشات من') {
        $stmt = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
        $row = $stmt->fetch();
        if(!$row || !$row['mobile']) {
            sendMessage($chat_id, "برای مشاهده سفارشات، ابتدا شماره موبایل خود را ثبت کنید.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $mobile = $row['mobile'];
        $url = "https://goldencheat.ir/wp-json/wc/v3/orders?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET . "&status=processing,completed,refunded";
        $response = @file_get_contents($url);
        $orders = json_decode($response, true);
        $user_orders = [];
        if($orders && is_array($orders)) {
            foreach($orders as $order) {
                $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
                if($order_mobile == $mobile) {
                    $user_orders[] = $order;
                }
            }
        }
        if(!$user_orders) {
            sendMessage($chat_id, "سفارشی برای شما یافت نشد.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $status_map = [
            'processing' => 'در حال انجام',
            'completed' => 'تکمیل‌شده',
            'refunded' => 'مسترد شده',
            'cancelled' => 'لغو شده',
            'pending' => 'در انتظار پرداخت'
        ];
        $text_orders = "📋 لیست سفارشات شما:\n";
        $inline_keyboard = [];
        foreach($user_orders as $order) {
            $oid = $order['id'];
            $pname = $order['line_items'][0]['name'] ?? '-';
            $status_fa = $status_map[$order['status']] ?? $order['status'];
            $text_orders .= "#{$oid} | {$pname} | وضعیت: {$status_fa}\n";
            $inline_keyboard[] = [
                ['text' => "🎓 دریافت آموزش سفارش #{$oid}", 'callback_data' => "my_order_training_{$oid}"]
            ];
        }
        $inline_keyboard[] = [ ['text'=>'🔙 بازگشت','callback_data'=>'main_menu'] ];
        sendMessage($chat_id, $text_orders, ['inline_keyboard'=>$inline_keyboard]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // دکمه لایسنس های من
    if($text == '🔑 لایسنس های من') {
        // دریافت شماره موبایل کاربر
        $stmt = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
        $row = $stmt->fetch();
        $mobile = $row ? $row['mobile'] : null;
        if(!$mobile) {
            sendMessage($chat_id, "شماره موبایل شما یافت نشد. لطفاً ابتدا شماره موبایل خود را ثبت کنید.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $mobile_norm = normalizeMobile($mobile);
        // دریافت سفارش‌های کاربر از ووکامرس (فقط سفارش‌های تکمیل شده یا در حال انجام)
        $url = "https://goldencheat.ir/wp-json/wc/v3/orders?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET . "&status=processing,completed";
        $response = @file_get_contents($url);
        $orders = json_decode($response, true);
        $user_orders = [];
        if($orders && is_array($orders)) {
            foreach($orders as $order) {
                $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
                if($order_mobile == $mobile_norm) {
                    $user_orders[] = $order;
                }
            }
        }
        if(empty($user_orders)) {
            sendMessage($chat_id, "❌ شما هیچ سفارش تکمیل شده یا در حال انجامی ندارید.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // مرتب‌سازی بر اساس تاریخ (جدیدترین اول)
        usort($user_orders, function($a, $b) {
            return strtotime($b['date_created']) - strtotime($a['date_created']);
        });
        $status_map = [
            'processing' => 'در حال انجام',
            'completed' => 'تکمیل‌شده',
            'refunded' => 'مسترد شده',
            'cancelled' => 'لغو شده',
            'pending' => 'در انتظار پرداخت'
        ];
        $text_orders = "🔑 <b>لایسنس های من</b>\n\n";
        $inline_keyboard = [];
        foreach($user_orders as $order) {
            $oid = $order['id'];
            $pname = $order['line_items'][0]['name'] ?? '-';
            $status_fa = $status_map[$order['status']] ?? $order['status'];
            $text_orders .= "📦 سفارش #{$oid}\n";
            $text_orders .= "محصول: {$pname}\n";
            $text_orders .= "وضعیت: {$status_fa}\n\n";
            $inline_keyboard[] = [
                ['text' => "📦 سفارش #{$oid} - {$pname}", 'callback_data' => "my_license_order_{$oid}"]
            ];
        }
        $inline_keyboard[] = [ ['text'=>'🔙 بازگشت','callback_data'=>'main_menu'] ];
        sendMessage($chat_id, $text_orders, ['inline_keyboard'=>$inline_keyboard]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // دکمه پنل مدیریت
    if($text == '🛠 پنل مدیریت' && $is_admin) {
        $reply_keyboard = [
            'keyboard' => [
                [['text' => '🎮 مدیریت آموزش محصولات']],
                [['text' => '🔑 مدیریت لایسنس محصولات']],
                [['text' => '🎁 تخفیف خرید مجدد']],
                [['text' => '📊 آمار ربات']],
                $user_id == ADMIN_ID ? [['text' => '🧑‍💼 مدیریت ادمین‌ها']] : [],
                [['text' => '🛒 لیست سفارشات جدید']],
                [['text' => '👤 کاربران اخیر']],
                [['text' => '📢 پیام همگانی']],
                [['text' => '🔙 بازگشت']],
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
        sendMessage($chat_id, '🛠 پنل مدیریت:\nیکی از گزینه‌های زیر را انتخاب کنید.', $reply_keyboard);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // دکمه‌های مدیریتی دیگر (نمونه)
    if($text == '🎮 مدیریت آموزش محصولات' && $is_admin) {
        $products = getProductsFromApi();
        $inline_keyboard = [];
        $text_products = '📦 محصولات:\n';
        foreach($products as $p) {
            $inline_keyboard[] = [
                ['text' => "📦 {$p['name']}", 'callback_data' => 'admin_trainings_' . $p['id']]
            ];
            $text_products .= "📦 {$p['name']}\n";
        }
        $inline_keyboard[] = [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_panel'] ];
        sendMessage($chat_id, $text_products . "\nبرای مدیریت آموزش هر محصول، روی دکمه آن کلیک کنید.", ['inline_keyboard'=>$inline_keyboard]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    if($text == '🎁 تخفیف خرید مجدد' && $is_admin) {
        showRepeatPurchaseDiscountProductsList($chat_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // بررسی handlerهای تخفیف خرید مجدد در بخش پیام متنی
    if($is_admin && file_exists("rpd_setpercent_{$user_id}.tmp")) {
        $info = json_decode(@file_get_contents("rpd_setpercent_{$user_id}.tmp"), true);
        @unlink("rpd_setpercent_{$user_id}.tmp");
        if(!$info || !isset($info['product_id']) || !isset($info['variation_id'])) {
            sendMessage($chat_id, 'خطا در دریافت اطلاعات.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $product_id = (int)$info['product_id'];
        $variation_id = (int)$info['variation_id'];
        $percent = intval(trim($text));
        if($percent < 5 || $percent > 60) {
            sendMessage($chat_id, 'درصد تخفیف باید بین 5 تا 60 باشد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $discount = getRepeatPurchaseDiscount($product_id, $variation_id);
        $is_active = $discount ? $discount['is_active'] : 0;
        $min_purchase = $discount ? $discount['min_purchase_count'] : 1;
        $min_days = $discount ? $discount['min_days_since_last_purchase'] : 0;
        $custom_msg = $discount ? $discount['custom_message'] : '';
        saveRepeatPurchaseDiscount($product_id, $variation_id, $percent, $is_active, $min_purchase, $min_days, $custom_msg);
        sendMessage($chat_id, "درصد تخفیف {$percent}% با موفقیت تنظیم شد.");
        showRepeatPurchaseDiscountSettings($chat_id, $product_id, $variation_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    if($is_admin && file_exists("rpd_setminpurchase_{$user_id}.tmp")) {
        $info = json_decode(@file_get_contents("rpd_setminpurchase_{$user_id}.tmp"), true);
        @unlink("rpd_setminpurchase_{$user_id}.tmp");
        if(!$info || !isset($info['product_id']) || !isset($info['variation_id'])) {
            sendMessage($chat_id, 'خطا در دریافت اطلاعات.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $product_id = (int)$info['product_id'];
        $variation_id = (int)$info['variation_id'];
        $min_purchase = intval(trim($text));
        if($min_purchase < 1) {
            sendMessage($chat_id, 'حداقل تعداد خرید باید 1 یا بیشتر باشد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $discount = getRepeatPurchaseDiscount($product_id, $variation_id);
        $percent = $discount ? $discount['discount_percent'] : 0;
        $is_active = $discount ? $discount['is_active'] : 0;
        $min_days = $discount ? $discount['min_days_since_last_purchase'] : 0;
        $custom_msg = $discount ? $discount['custom_message'] : '';
        saveRepeatPurchaseDiscount($product_id, $variation_id, $percent, $is_active, $min_purchase, $min_days, $custom_msg);
        sendMessage($chat_id, "حداقل تعداد خرید {$min_purchase} با موفقیت تنظیم شد.");
        showRepeatPurchaseDiscountSettings($chat_id, $product_id, $variation_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    if($is_admin && file_exists("rpd_setmindays_{$user_id}.tmp")) {
        $info = json_decode(@file_get_contents("rpd_setmindays_{$user_id}.tmp"), true);
        @unlink("rpd_setmindays_{$user_id}.tmp");
        if(!$info || !isset($info['product_id']) || !isset($info['variation_id'])) {
            sendMessage($chat_id, 'خطا در دریافت اطلاعات.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $product_id = (int)$info['product_id'];
        $variation_id = (int)$info['variation_id'];
        $min_days = intval(trim($text));
        if($min_days < 0) {
            sendMessage($chat_id, 'حداقل روز باید 0 یا بیشتر باشد (0 یعنی بدون محدودیت).');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $discount = getRepeatPurchaseDiscount($product_id, $variation_id);
        $percent = $discount ? $discount['discount_percent'] : 0;
        $is_active = $discount ? $discount['is_active'] : 0;
        $min_purchase = $discount ? $discount['min_purchase_count'] : 1;
        $custom_msg = $discount ? $discount['custom_message'] : '';
        saveRepeatPurchaseDiscount($product_id, $variation_id, $percent, $is_active, $min_purchase, $min_days, $custom_msg);
        if($min_days == 0) {
            sendMessage($chat_id, "محدودیت روز حذف شد (بدون محدودیت).");
        } else {
            sendMessage($chat_id, "حداقل {$min_days} روز از آخرین خرید با موفقیت تنظیم شد.");
        }
        showRepeatPurchaseDiscountSettings($chat_id, $product_id, $variation_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    if($is_admin && file_exists("rpd_setmessage_{$user_id}.tmp")) {
        $info = json_decode(@file_get_contents("rpd_setmessage_{$user_id}.tmp"), true);
        @unlink("rpd_setmessage_{$user_id}.tmp");
        if(!$info || !isset($info['product_id']) || !isset($info['variation_id'])) {
            sendMessage($chat_id, 'خطا در دریافت اطلاعات.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $product_id = (int)$info['product_id'];
        $variation_id = (int)$info['variation_id'];
        $custom_msg = trim($text);
        $discount = getRepeatPurchaseDiscount($product_id, $variation_id);
        $percent = $discount ? $discount['discount_percent'] : 0;
        $is_active = $discount ? $discount['is_active'] : 0;
        $min_purchase = $discount ? $discount['min_purchase_count'] : 1;
        $min_days = $discount ? $discount['min_days_since_last_purchase'] : 0;
        saveRepeatPurchaseDiscount($product_id, $variation_id, $percent, $is_active, $min_purchase, $min_days, $custom_msg);
        sendMessage($chat_id, "پیام سفارشی با موفقیت تنظیم شد.");
        showRepeatPurchaseDiscountSettings($chat_id, $product_id, $variation_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    if($text == '📊 آمار ربات' && $is_admin) {
        $ustats = getUserStats();
        $order_count = getOrderStatsFromApi();
        $order_count_db = getOrderStatsFromDb();
        $msg = "📊 آمار ربات:\n";
        $msg .= "👤 کاربران امروز: {$ustats['today']}\n";
        $msg .= "👥 کاربران ماه: {$ustats['month']}\n";
        $msg .= "👥 کل کاربران: {$ustats['total']}\n";
        $msg .= "🛒 کل سفارشات سایت: {$order_count}\n";
        $msg .= "📦 آموزش‌های ارسال‌شده توسط ربات: {$order_count_db}";
        sendMessage($chat_id, $msg);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    if($text == '🧑‍💼 مدیریت ادمین‌ها' && $is_admin) {
        $keyboard = [
            'inline_keyboard' => [
                [ ['text' => '➕ افزودن ادمین جدید', 'callback_data' => 'admin_addadmin'] ],
                [ ['text' => '➖ حذف ادمین', 'callback_data' => 'admin_deladmin'] ],
                [ ['text' => '👥 لیست ادمین‌ها', 'callback_data' => 'admin_admins'] ],
                [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_panel'] ],
            ]
        ];
        sendMessage($chat_id, 'مدیریت ادمین‌ها:
یکی از گزینه‌های زیر را انتخاب کنید.', $keyboard);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    if($text == '🛒 لیست سفارشات جدید' && $is_admin) {
        $page = 0;
        $per_page = 5;
        $offset = $page * $per_page;
        $url = "https://goldencheat.ir/wp-json/wc/v3/orders?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET . "&status=processing&orderby=date&order=desc&per_page=$per_page&offset=$offset";
        $response = @file_get_contents($url);
        $orders = json_decode($response, true);
        if(!$orders || !is_array($orders)) {
            sendMessage($chat_id, 'سفارشی یافت نشد یا ارتباط با سایت برقرار نشد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $keyboard = [
            'keyboard' => [],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
        $text_orders = "📋 لیست سفارشات جدید:\n";
        foreach($orders as $order) {
            $order_id = $order['id'];
            $name = $order['billing']['first_name'] . ' ' . $order['billing']['last_name'];
            $status = $order['status'];
            $btn = [['text' => "🧾 سفارش #{$order_id} | {$name}"]];
            $keyboard['keyboard'][] = $btn;
            $text_orders .= "🧾 سفارش #{$order_id} | {$name} | وضعیت: {$status}\n";
        }
        $keyboard['keyboard'][] = [['text' => '🔙 بازگشت']];
        sendMessage($chat_id, $text_orders . "\nبرای مشاهده جزئیات، روی دکمه سفارش کلیک کنید.", $keyboard);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    if($text == '👤 کاربران اخیر' && $is_admin) {
        $per_page = 10;
        $stmt = dbQuery("SELECT telegram_id, mobile, created_at FROM users WHERE mobile IS NOT NULL AND mobile != '' ORDER BY created_at DESC LIMIT $per_page");
        $users = $stmt->fetchAll();
        $text_users = '👤 ۱۰ کاربر اخیر ثبت‌نام‌شده:\n';
        $inline_keyboard = [];
        foreach($users as $u) {
            $mobile = $u['mobile'] ? $u['mobile'] : '---';
            $created = $u['created_at'];
            $btn_text = "👤 {$mobile} | ثبت: {$created}";
            $inline_keyboard[] = [ ['text' => $btn_text, 'callback_data' => 'admin_manageuser_' . $u['telegram_id']] ];
            $text_users .= $btn_text . "\n";
        }
        $reply_markup = [
            'inline_keyboard' => $inline_keyboard
        ];
        sendMessage($chat_id, $text_users . "\nبرای مدیریت هر کاربر روی دکمه کلیک کنید.", $reply_markup);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    if($text == '📢 پیام همگانی' && $is_admin) {
        sendMessage($chat_id, 'متن پیام همگانی را وارد کنید:', ["force_reply" => true]);
        file_put_contents("broadcast_{$user_id}.tmp", 1);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // هندل دستور /start یا بازگشت به منو
    if($text == '/start' || $text == 'بازگشت به منو' || strtolower($text) == 'menu') {
        error_log("Start command received from user {$user_id} in chat {$chat_id}");
        
        // بررسی شماره موبایل
        $stmt_mobile = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
        $row_mobile = $stmt_mobile->fetch();
        if(!$row_mobile || !$row_mobile['mobile']) {
            error_log("User {$user_id} has no mobile, showing contact request");
            $contact_keyboard = [
                'keyboard' => [
                    [ ['text' => '📱 ارسال شماره من', 'request_contact' => true] ]
                ],
                'resize_keyboard' => true,
                'one_time_keyboard' => true
            ];
            sendMessage($chat_id, "📱 لطفاً شماره موبایل خود را با دکمه زیر ارسال کنید:\n\n⚠️ حتما از دکمه پایین یعنی 'ارسال شماره من' باید شماره خودتون رو ارسال بکنید\n\n❗️ نکته مهم اینکه اگه از داخل سایت سفارشی ثبت کردین باید و حتما همون شماره داخل تلگرام عضو بشین و با همون شماره اقدام بکنید هیچ راه دیگه ای وجود نداره", $contact_keyboard);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        
        error_log("User {$user_id} has mobile, showing start menu");
        showStartMenu($chat_id, $is_admin);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // دکمه خرید چیت
    if($text == '🛒 خرید چیت') {
        $products = getProductsFromApi();
        $filtered_products = [];
        foreach($products as $p) {
            // فقط محصولات قابل خرید و موجود
            if((isset($p["status"]) && $p["status"] !== "publish") || (isset($p["stock_status"]) && $p["stock_status"] !== "instock")) continue;
            if(isset($p["type"]) && !in_array($p["type"], ["simple", "variable"])) continue;
            // اگر محصول variable است، باید حداقل یک متغیر فعال داشته باشد
            if(isset($p["type"]) && $p["type"] == "variable") {
                $vars = getProductVariationsFromApi($p["id"]);
                if(!is_array($vars) || count($vars) == 0) continue;
            }
            $filtered_products[] = $p;
        }
        if(!$filtered_products) {
            sendMessage($chat_id, 'در حال حاضر محصولی برای خرید موجود نیست.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $reply_keyboard = [
            'keyboard' => [],
            'resize_keyboard' => true,
            'one_time_keyboard' => true
        ];
        foreach($filtered_products as $p) {
            $reply_keyboard['keyboard'][] = [ ['text' => $p['name']] ];
        }
        $reply_keyboard['keyboard'][] = [ ['text' => '🔙 بازگشت'] ];
        sendMessage($chat_id, 'لطفاً یکی از محصولات زیر را برای خرید انتخاب کنید:', $reply_keyboard);
        // ذخیره لیست محصولات برای هندل انتخاب بعدی
        file_put_contents("buy_products_{$user_id}.tmp", json_encode($filtered_products));
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // هندل انتخاب محصول خرید چیت با دکمه معمولی
    if(isset($update['message']['text']) && file_exists("buy_products_{$user_id}.tmp")) {
        $products = @json_decode(@file_get_contents("buy_products_{$user_id}.tmp"), true);
        $selected_name = $text;
        $selected_id = null;
        foreach($products as $p) {
            if($p['name'] == $selected_name) $selected_id = $p['id'];
        }
        if($selected_id) {
            // حذف فایل موقت لیست محصولات
            @unlink("buy_products_{$user_id}.tmp");
            // شبیه‌سازی callback_query برای ادامه روند خرید
            $data = 'buy_product_' . $selected_id;
            // اجرای هندل انتخاب متغیرها
            // ... ادامه روند خرید چیت ...
            // (کد قبلی buy_product_ را اینجا فراخوانی کن)
            // دریافت متغیرهای محصول از ووکامرس
            $url = WC_API_URL . "/$selected_id/variations?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
            $response = @file_get_contents($url);
            $vars = json_decode($response, true);
            if(!$vars || !is_array($vars) || count($vars) == 0) {
                sendMessage($chat_id, 'برای این محصول متغیری جهت انتخاب وجود ندارد یا محصول قابل خرید نیست.');
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            // مرحله اول انتخاب ویژگی (attribute)
            $attributes = $vars[0]['attributes'] ?? [];
            if(!$attributes) {
                sendMessage($chat_id, 'برای این محصول متغیری جهت انتخاب وجود ندارد.');
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            // ذخیره انتخاب محصول و مرحله خرید
            file_put_contents("buy_step_{$user_id}.tmp", json_encode(['product_id'=>$selected_id, 'step'=>0, 'selected'=>[]]));
            // نمایش اولین ویژگی برای انتخاب
            $attr = $attributes[0]['name'];
            $options = [];
            foreach($vars as $v) {
                foreach($v['attributes'] as $a) {
                    if($a['name'] == $attr && !in_array($a['option'], $options)) $options[] = $a['option'];
                }
            }
            $reply_keyboard = [
                'keyboard' => [],
                'resize_keyboard' => true,
                'one_time_keyboard' => true
            ];
            foreach($options as $opt) {
                // نمایش مستقیم گزینه بدون urldecode چون از API مستقیماً می‌آید
                $reply_keyboard['keyboard'][] = [ ['text'=>$opt] ];
            }
            $reply_keyboard['keyboard'][] = [ ['text'=>'🔙 بازگشت'] ];
            sendMessage($chat_id, "📦 $selected_name\nلطفاً گزینه مورد نظر برای '$attr' را انتخاب کنید:", $reply_keyboard);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
    }
    // انتخاب سفارش از لیست سفارشات جدید
    if($is_admin && strpos($text, '🧾 سفارش #') === 0) {
        // استخراج شماره سفارش
        if(preg_match('/^🧾 سفارش #(\d+)/u', $text, $m)) {
            $order_id = $m[1];
            $url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
            $response = @file_get_contents($url);
            $order = json_decode($response, true);
            if(!$order || !isset($order['id'])) {
                sendMessage($chat_id, "سفارش یافت نشد یا ارتباط با سایت برقرار نشد.");
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            $products = [];
            foreach($order['line_items'] as $item) {
                $products[] = $item['name'];
            }
            $products_str = implode('، ', $products);
            $status_map = [
                'processing' => 'در حال انجام',
                'completed' => 'تکمیل‌شده',
                'refunded' => 'مسترد شده',
                'pending' => 'در انتظار پرداخت'
            ];
            $status_fa = $status_map[$order['status']] ?? $order['status'];
            $text_detail = "🔎 جزئیات سفارش #{$order['id']}\n";
            $text_detail .= "تاریخ: " . ($order['date_created'] ?? '-') . "\n";
            $text_detail .= "محصول(ها): {$products_str}\n";
            $text_detail .= "قیمت: " . ($order['total'] ?? '-') . " تومان\n";
            $text_detail .= "وضعیت: {$status_fa}\n";
            $text_detail .= "نام خریدار: " . ($order['billing']['first_name'] . ' ' . $order['billing']['last_name']) . "\n";
            $text_detail .= "ایمیل: " . ($order['billing']['email'] ?? '-') . "\n";
            $text_detail .= "تلفن: " . ($order['billing']['phone'] ?? '-') . "\n";
            // بررسی وضعیت عضویت کاربر
            $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
            $user_status = '⛔️ هنوز داخل ربات عضو نیست';
            if($order_mobile && strlen($order_mobile) === 11 && strpos($order_mobile, '09') === 0) {
                $stmt = dbQuery("SELECT telegram_id FROM users WHERE mobile = ?", [$order_mobile]);
                if($stmt->fetch()) {
                    $user_status = '✅ داخل ربات عضو است';
                }
            }
            $text_detail .= "وضعیت عضویت: {$user_status}\n";
            // دکمه‌های وضعیت سفارش + دکمه یادداشت
            $status_buttons = [];
            foreach($status_map as $key => $val) {
                $tick = ($order['status'] == $key) ? '✅ ' : '';
                $status_buttons[] = [['text' => $tick . $val . ($key=='processing'?' 🟡':($key=='completed'?' 🟢':($key=='refunded'?' 🔴':' ⏳'))),]];
            }
            $status_buttons[] = [['text' => '📝 اضافه کردن یادداشت برای کاربر']];
            $status_buttons[] = [['text' => '🚀 ارسال لایسنس به کاربر', 'callback_data' => 'admin_sendlicense_' . $order['id']]];
            $status_buttons[] = [['text' => '🔙 بازگشت']];
            // بررسی لایسنس آزاد برای محصول سفارش
            $free_license_exists = false;
            $free_license_count = 0;
            $product_id = $order['line_items'][0]['product_id'] ?? null;
            $variation_id = $order['line_items'][0]['variation_id'] ?? null;
            if($product_id && $variation_id) {
                $stmt = dbQuery("SELECT COUNT(*) as cnt FROM licenses WHERE product_id = ? AND variation_id = ? AND status = 'free'", [$product_id, $variation_id]);
                $row = $stmt->fetch();
                $free_license_count = $row ? intval($row['cnt']) : 0;
                if($free_license_count > 0) $free_license_exists = true;
            }
            $inline_license_buttons = [];
            if($free_license_exists) {
                $inline_license_buttons[] = [['text' => 'لایسنس آزاد موجود است 👇🏻', 'callback_data' => 'free_license_info_' . $order['id']]];
                $inline_license_buttons[] = [
                    ['text' => "تعداد موجودی ({$free_license_count})", 'callback_data' => 'free_license_count_' . $order['id']],
                    ['text' => 'ارسال لایسنس آزاد', 'callback_data' => 'send_free_license_' . $order['id']]
                ];
            }
            $reply_markup = [
                'keyboard' => $status_buttons,
                'resize_keyboard' => true,
                'one_time_keyboard' => false
            ];
            if($free_license_exists) {
                $reply_markup = [
                    'inline_keyboard' => array_merge($inline_license_buttons, [ [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_manageorder_' . $order['id']] ] ])
                ];
            }
            sendMessage($chat_id, $text_detail . "\nبرای تغییر وضعیت یا افزودن یادداشت، یکی از دکمه‌های زیر را انتخاب کنید.", $reply_markup);
            // ذخیره شماره سفارش برای تغییر وضعیت یا یادداشت بعدی
            file_put_contents("admin_selected_order_{$chat_id}.tmp", $order_id);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
    }
    // اضافه کردن یادداشت برای کاربر
    if($is_admin && file_exists("admin_selected_order_{$chat_id}.tmp") && $text == '📝 اضافه کردن یادداشت برای کاربر') {
        $order_id = @file_get_contents("admin_selected_order_{$chat_id}.tmp");
        sendMessage($chat_id, 'متن یادداشت را وارد کنید (این یادداشت برای کاربر ارسال می‌شود):', ["force_reply" => true]);
        file_put_contents("admin_addnote_{$chat_id}.tmp", $order_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // ثبت یادداشت و ارسال به کاربر
    if($is_admin && file_exists("admin_addnote_{$chat_id}.tmp") && isset($update['message']['text']) && $text != '📝 اضافه کردن یادداشت برای کاربر') {
        $order_id = @file_get_contents("admin_addnote_{$chat_id}.tmp");
        @unlink("admin_addnote_{$chat_id}.tmp");
        // افزودن یادداشت به ووکامرس
        $url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}/notes?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
        $payload = json_encode([
            'note' => $text,
            'customer_note' => true
        ]);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length' => strlen($payload)
        ]);
        $result = curl_exec($ch);
        curl_close($ch);
        sendMessage($chat_id, 'یادداشت با موفقیت ثبت و برای کاربر ارسال شد.');
        // ارسال یادداشت به کاربر
        $order_url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
        $order = json_decode(@file_get_contents($order_url), true);
        $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
        if($order_mobile && strlen($order_mobile) === 11 && strpos($order_mobile, '09') === 0) {
            $stmt = dbQuery("SELECT telegram_id FROM users WHERE mobile = ?", [$order_mobile]);
            if($row = $stmt->fetch()) {
                sendMessage($row['telegram_id'], "یادداشت جدید برای سفارش شما (#{$order_id}):\n" . $text);
            }
        }
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // تغییر وضعیت سفارش توسط ادمین
    if($is_admin && file_exists("admin_selected_order_{$chat_id}.tmp")) {
        $order_id = @file_get_contents("admin_selected_order_{$chat_id}.tmp");
        $status_map = [
            'processing' => 'در حال انجام',
            'completed' => 'تکمیل‌شده',
            'refunded' => 'مسترد شده',
            'pending' => 'در انتظار پرداخت'
        ];
        $status_keys = array_keys($status_map);
        $selected_status = null;
        foreach($status_map as $key => $val) {
            if(strpos($text, $val) !== false) {
                $selected_status = $key;
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                break;
            }
        }
        if($selected_status && $order_id) {
            // تغییر وضعیت در ووکامرس
            $url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
            $payload = json_encode(['status' => $selected_status]);
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Content-Length: ' . strlen($payload)
            ]);
            $result = curl_exec($ch);
            curl_close($ch);
            @unlink("admin_selected_order_{$chat_id}.tmp");
            // پیام به ادمین
            sendMessage($chat_id, "وضعیت سفارش #{$order_id} با موفقیت تغییر کرد به: " . $status_map[$selected_status]);
            // پیام به کاربر
            $order = json_decode(@file_get_contents($url), true);
            $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
            if($order_mobile && strlen($order_mobile) === 11 && strpos($order_mobile, '09') === 0) {
                $stmt = dbQuery("SELECT telegram_id FROM users WHERE mobile = ?", [$order_mobile]);
                if($row = $stmt->fetch()) {
                    sendMessage($row['telegram_id'], "وضعیت سفارش شما (#{$order_id}) به '{$status_map[$selected_status]}' تغییر یافت.");
                }
            }
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
    }
}

// --- دریافت و ثبت شماره تماس کاربر ---
if(isset($update['message']['contact']) && isset($update['message']['contact']['phone_number'])) {
    $chat_id = $update['message']['chat']['id'];
    $user_id = $update['message']['from']['id'];
    $phone = normalizeMobile($update['message']['contact']['phone_number']);
    // اگر کاربر وجود ندارد، ابتدا ثبت کن
    $stmt = dbQuery("SELECT id FROM users WHERE telegram_id = ?", [$user_id]);
    if(!$stmt->fetch()) {
        dbQuery("INSERT INTO users (telegram_id, mobile) VALUES (?, ?)", [$user_id, $phone]);
    } else {
        dbQuery("UPDATE users SET mobile = ? WHERE telegram_id = ?", [$phone, $user_id]);
    }
    sendMessage($chat_id, "شماره موبایل شما با موفقیت ثبت شد ✅", [
        'remove_keyboard' => true
    ]);
    // ارسال پیام به ادمین‌ها درباره ثبت‌نام کاربر جدید
    $order_count = 0;
    $url = "https://goldencheat.ir/wp-json/wc/v3/orders?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET . "&status=processing";
    $response = @file_get_contents($url);
    $orders = json_decode($response, true);
    if($orders && is_array($orders)) {
        foreach($orders as $order) {
            $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
            if($order_mobile == $phone) {
                $order_count++;
                $order_id = $order['id'];
                $license_found = false;
                // بررسی لایسنس تخصیص یافته اما ارسال نشده
                foreach($order['line_items'] as $item) {
                    $product_id = $item['product_id'];
                    $variation_id = $item['variation_id'] ?? 0;
                    if($product_id && $variation_id) {
                        $stmt = dbQuery("SELECT * FROM licenses WHERE product_id = ? AND variation_id = ? AND assigned_to_order = ? AND (assigned_to_user IS NULL OR assigned_to_user = 0 OR assigned_to_user = '')", [$product_id, $variation_id, $order_id]);
                        if($lic = $stmt->fetch()) {
                            $license_found = true;
                            // ارسال لایسنس به کاربر با قالب وایب‌دار
                            $msg = "🚨 خبر داغ از گلدن چیت 🍾\n🎩 ساقی انواع چیت‌های ارجینال رسید خدمتتون 😌💼\n💉 دوز مخصوص امروز: لایسنس چیت خفن شما!\n\n🎮 🔑 <code>{$lic['license_key']}</code> 🔑 🎮\n\n🔥 با احتیاط مصرف شَوَد؛ ممکنه اعتیاد پیدا بکنی 😈😂\nاگه مشکلی بود، ساقی همیشه آنلاینه 💬📲";
                            sendMessage($chat_id, $msg);
                            // ثبت assigned_to_user
                            $stmt = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
                            $row = $stmt->fetch();
                            $mobile = $row ? $row['mobile'] : '';
                            dbQuery("UPDATE licenses SET assigned_to_user = ? WHERE id = ?", [$mobile, $lic['id']]);
                            // افزودن یادداشت به سفارش در ووکامرس
                            $note = "لایسنس شما: {$lic['license_key']}";
                            $url_note = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}/notes?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
                            $payload = json_encode([
                                'note' => $note,
                                'customer_note' => true
                            ]);
                            $ch = curl_init($url_note);
                            curl_setopt($ch, CURLOPT_POST, 1);
                            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                                'Content-Type: application/json',
                                'Content-Length' => strlen($payload)
                            ]);
                            $result = curl_exec($ch);
                            curl_close($ch);
                            // تغییر وضعیت سفارش به completed
                            $url_status = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
                            $payload_status = json_encode(['status' => 'completed']);
                            $ch_status = curl_init($url_status);
                            curl_setopt($ch_status, CURLOPT_CUSTOMREQUEST, "PUT");
                            curl_setopt($ch_status, CURLOPT_POSTFIELDS, $payload_status);
                            curl_setopt($ch_status, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch_status, CURLOPT_HTTPHEADER, [
                                'Content-Type: application/json',
                                'Content-Length' => strlen($payload_status)
                            ]);
                            $result_status = curl_exec($ch_status);
                            curl_close($ch_status);
                        } else {
                            // اگر نبود، دنبال لایسنس آزاد بگرد و همانجا تخصیص بده
                            $stmt2 = dbQuery("SELECT * FROM licenses WHERE product_id = ? AND variation_id = ? AND status = 'free' LIMIT 1", [$product_id, $variation_id]);
                            if($lic2 = $stmt2->fetch()) {
                                $license_found = true;
                                // دریافت شماره موبایل کاربر
                                $stmt_user = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
                                $user_mobile = $stmt_user->fetch()['mobile'];
                                $user_mobile_norm = normalizeMobile($user_mobile);
                                
                                dbQuery("UPDATE licenses SET status = 'assigned', assigned_to_order = ?, assigned_to_user = ?, assigned_at = NOW() WHERE id = ?", [$order_id, $user_mobile_norm, $lic2['id']]);
                                // ارسال لایسنس به کاربر با قالب وایب‌دار
                                $msg = "🚨 خبر داغ از گلدن چیت 🍾\n🎩 ساقی انواع چیت‌های ارجینال رسید خدمتتون 😌💼\n💉 دوز مخصوص امروز: لایسنس چیت خفن شما!\n\n🎮 🔑 <code>{$lic2['license_key']}</code> 🔑 🎮\n\n🔥 با احتیاط مصرف شَوَد؛ ممکنه اعتیاد پیدا بکنی 😈😂\nاگه مشکلی بود، ساقی همیشه آنلاینه 💬📲";
                                sendMessage($chat_id, $msg);
                                // ارسال پیام به ادمین‌ها با جزئیات سفارش
$admin_message = "✅ شماره سفارش: #{$order_id} با موفقیت لایسنس ارسال شد و وضعیت سفارش به تکمیل شده تغییر کرد.\n";
$admin_message .= "🔰 جزئییات سفارش:\n";
$admin_message .= "محصول(ها): " . implode(', ', array_map(function($item) {
    return $item['name'];
}, $order['line_items'])) . "\n";
$admin_message .= "نام خریدار: " . $order['billing']['first_name'] . ' ' . $order['billing']['last_name'] . "\n";
$admin_message .= "وضعیت کاربر: عضو ربات است\n";  // یا می‌توانید وضعیت را بر اساس موجود بودن در ربات تغییر دهید
$admin_message .= "وضعیت: تکمیل شده\n";
$admin_message .= "لایسنس ارسالی: {$lic2['license_key']}";

// ارسال پیام فقط به ادمین اصلی
sendMessage(ADMIN_ID, $admin_message);

                                // افزودن یادداشت به سفارش در ووکامرس
                                $note = "لایسنس شما: {$lic2['license_key']}";
                                $url_note = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}/notes?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
                                $payload = json_encode([
                                    'note' => $note,
                                    'customer_note' => true
                                ]);
                                $ch = curl_init($url_note);
                                curl_setopt($ch, CURLOPT_POST, 1);
                                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                                    'Content-Type: application/json',
                                    'Content-Length' => strlen($payload)
                                ]);
                                $result = curl_exec($ch);
                                curl_close($ch);
                                // تغییر وضعیت سفارش به completed
                                $url_status = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
                                $payload_status = json_encode(['status' => 'completed']);
                                $ch_status = curl_init($url_status);
                                curl_setopt($ch_status, CURLOPT_CUSTOMREQUEST, "PUT");
                                curl_setopt($ch_status, CURLOPT_POSTFIELDS, $payload_status);
                                curl_setopt($ch_status, CURLOPT_RETURNTRANSFER, true);
                                curl_setopt($ch_status, CURLOPT_HTTPHEADER, [
                                    'Content-Type: application/json',
                                    'Content-Length' => strlen($payload_status)
                                ]);
                                $result_status = curl_exec($ch_status);
                                curl_close($ch_status);
                            }
                        }
                        // اگر هیچ لایسنسی پیدا نشد، به ادمین پیام بده
                        if(!$license_found) {
                            $admin_stmt = dbQuery("SELECT telegram_id FROM admins");
                            // ارسال هشدار فقط به ادمین اصلی
                            $alert = "⚠️ لایسنس برای سفارش #{$order_id} پیدا نشد! لطفاً پیگیری شود.";
                            sendMessage(ADMIN_ID, $alert);
                        }
                    }
                }
            }
        }
    }
    $stmt_admins = dbQuery("SELECT telegram_id FROM admins");
    while($row = $stmt_admins->fetch()) {
        $admin_id = $row['telegram_id'];
        $msg = "🔔 کاربر جدید با شماره \"$phone\" و تعداد سفارش \"$order_count\" در ربات ثبت نام کرد!";
        $inline = [
            'inline_keyboard' => [
                [ ['text'=>'📦 مشاهده سفارشات','callback_data'=>'admin_manageuser_' . $user_id] ]
            ]
        ];
        sendMessage($admin_id, $msg, $inline);
    }
    $is_admin = ($user_id == ADMIN_ID);
    showStartMenu($chat_id, $is_admin);
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// اگر سفارش جدید ثبت شد و وضعیتش processing بود، به ادمین پیام بده
if(isset($update['order']) && isset($update['order']['id']) && $update['order']['status'] == 'processing') {
    notifyAdminsOrderProcessing($update['order']['id']);
}
// مدیریت callback_query برای منوها و مدیریت
if(isset($update['callback_query'])) {
    $chat_id = $update['callback_query']['message']['chat']['id'];
    $user_id = $update['callback_query']['from']['id'];
    $data = $update['callback_query']['data'] ?? '';
    $message_id = $update['callback_query']['message']['message_id'];
    $stmt_admin = dbQuery("SELECT telegram_id FROM admins WHERE telegram_id = ?", [$user_id]);
    $is_admin = ($user_id == ADMIN_ID) || ($stmt_admin->fetch());
    $loading_message_id = sendMessage($chat_id, '⏳ در حال بارگذاری، لطفا صبور باشید...');
    if($data == 'get_my_training') {
        sendMessage($chat_id, 'لطفاً شماره سفارش خود را وارد کنید 🧾', ["force_reply" => true]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif($data == 'main_menu' || $data == '/start') {
        showStartMenu($chat_id, $is_admin, $message_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif($data == 'admin_panel' && $is_admin) {
        $reply_keyboard = [
            'keyboard' => [
                [['text' => 'مدیریت آموزش محصولات']],
                [['text' => 'آمار ربات']],
                $user_id == ADMIN_ID ? [['text' => 'مدیریت ادمین‌ها']] : [],
                [['text' => 'لیست سفارشات جدید']],
                [['text' => 'کاربران اخیر']],
                [['text' => 'پیام همگانی']],
                [['text' => 'خروج']],
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
        editMessage($chat_id, $message_id, '🛠 پنل مدیریت:
برای انتخاب هر بخش، متن آن را ارسال کنید.', $reply_keyboard);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif($data == 'rpd_list' && $is_admin) {
        showRepeatPurchaseDiscountProductsList($chat_id, $message_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'rpd_product_') === 0 && $is_admin) {
        $product_id = str_replace('rpd_product_', '', $data);
        showRepeatPurchaseDiscountProductDetails($chat_id, $product_id, $message_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'rpd_edit_') === 0 && $is_admin) {
        $parts = explode('_', $data);
        $product_id = $parts[2] ?? 0;
        $variation_id = $parts[3] ?? 0;
        showRepeatPurchaseDiscountSettings($chat_id, $product_id, $variation_id, $message_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'rpd_toggle_') === 0 && $is_admin) {
        $parts = explode('_', $data);
        $product_id = (int)($parts[2] ?? 0);
        $variation_id = (int)($parts[3] ?? 0);
        $discount = getRepeatPurchaseDiscount($product_id, $variation_id);
        $old_status = $discount ? (int)$discount['is_active'] : 0;
        // toggle: اگر فعال بود غیرفعال کن، اگر غیرفعال بود فعال کن
        $new_status = ($old_status == 1) ? 0 : 1;
        $discount_percent = $discount ? (int)$discount['discount_percent'] : 0;
        $min_purchase = $discount ? (int)$discount['min_purchase_count'] : 1;
        $min_days = $discount ? (int)$discount['min_days_since_last_purchase'] : 0;
        $custom_msg = $discount ? $discount['custom_message'] : '';
        
        // اگر درصد تخفیف تنظیم نشده، پیش‌فرض 5% بگذار
        if($discount_percent == 0 && !$discount) {
            $discount_percent = 5;
        }
        
        saveRepeatPurchaseDiscount($product_id, $variation_id, $discount_percent, $new_status, $min_purchase, $min_days, $custom_msg);
        
        // اگر تخفیف از غیرفعال به فعال تغییر کرد، به کاربران واجد شرایط اطلاع بده
        if($old_status == 0 && $new_status == 1 && $discount_percent > 0) {
            sendMessage($chat_id, "⏳ در حال ارسال پیام اطلاع‌رسانی به کاربران واجد شرایط...");
            $notification_result = notifyEligibleUsersForDiscount($product_id, $variation_id);
            if($notification_result) {
                $error_details = '';
                if($notification_result['error'] > 0 && isset($notification_result['error_details'])) {
                    $error_details = "\n\nخطاها:\n" . implode("\n", array_slice($notification_result['error_details'], 0, 5));
                    if(count($notification_result['error_details']) > 5) {
                        $error_details .= "\n... و " . (count($notification_result['error_details']) - 5) . " خطای دیگر";
                    }
                }
                sendMessage($chat_id, "✅ پیام اطلاع‌رسانی به {$notification_result['sent']} کاربر ارسال شد. ({$notification_result['error']} خطا){$error_details}");
            }
        }
        
        // کمی تاخیر برای اطمینان از ذخیره در دیتابیس
        usleep(200000); // 0.2 ثانیه
        
        // بررسی مجدد از دیتابیس برای اطمینان
        $verify_discount = getRepeatPurchaseDiscount($product_id, $variation_id);
        if($verify_discount) {
            $verify_status = (int)$verify_discount['is_active'];
            if($verify_status != $new_status) {
                // اگر وضعیت ذخیره نشده، دوباره تلاش کن
                saveRepeatPurchaseDiscount($product_id, $variation_id, $discount_percent, $new_status, $min_purchase, $min_days, $custom_msg);
                usleep(100000); // 0.1 ثانیه دیگر
            }
        }
        
        // نمایش مجدد تنظیمات با داده‌های جدید از دیتابیس
        showRepeatPurchaseDiscountSettings($chat_id, $product_id, $variation_id, $message_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'rpd_setpercent_') === 0 && $is_admin) {
        $parts = explode('_', $data);
        $product_id = $parts[2] ?? 0;
        $variation_id = $parts[3] ?? 0;
        file_put_contents("rpd_setpercent_{$user_id}.tmp", json_encode(['product_id' => $product_id, 'variation_id' => $variation_id]));
        sendMessage($chat_id, 'درصد تخفیف را وارد کنید (عدد بین 5 تا 60):', ["force_reply" => true]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'rpd_setminpurchase_') === 0 && $is_admin) {
        $parts = explode('_', $data);
        $product_id = $parts[2] ?? 0;
        $variation_id = $parts[3] ?? 0;
        file_put_contents("rpd_setminpurchase_{$user_id}.tmp", json_encode(['product_id' => $product_id, 'variation_id' => $variation_id]));
        sendMessage($chat_id, 'حداقل تعداد خرید قبلی را وارد کنید (حداقل 1):', ["force_reply" => true]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'rpd_setmindays_') === 0 && $is_admin) {
        $parts = explode('_', $data);
        $product_id = $parts[2] ?? 0;
        $variation_id = $parts[3] ?? 0;
        file_put_contents("rpd_setmindays_{$user_id}.tmp", json_encode(['product_id' => $product_id, 'variation_id' => $variation_id]));
        sendMessage($chat_id, 'حداقل تعداد روز گذشته از آخرین خرید را وارد کنید (0 یعنی بدون محدودیت):', ["force_reply" => true]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'rpd_setmessage_') === 0 && $is_admin) {
        $parts = explode('_', $data);
        $product_id = $parts[2] ?? 0;
        $variation_id = $parts[3] ?? 0;
        file_put_contents("rpd_setmessage_{$user_id}.tmp", json_encode(['product_id' => $product_id, 'variation_id' => $variation_id]));
        sendMessage($chat_id, 'پیام سفارشی برای نمایش به کاربر هنگام اعمال تخفیف را وارد کنید:', ["force_reply" => true]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'admin_trainings_') === 0 && $is_admin) {
        $product_id = str_replace('admin_trainings_', '', $data);
        adminShowProductMessages($chat_id, $product_id, $message_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'admin_addmsg_') === 0 && $is_admin) {
        $product_id = str_replace('admin_addmsg_', '', $data);
        file_put_contents("admin_addmsg_{$user_id}.tmp", $product_id);
        sendMessage($chat_id, 'پیام جدید (متن، عکس، ویدیو، ویس یا فوروارد) را ارسال کنید:', ["force_reply" => true]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'admin_clear_') === 0 && $is_admin) {
        $product_id = str_replace('admin_clear_', '', $data);
        dbQuery("DELETE FROM product_messages WHERE product_id = ?", [$product_id]);
        sendMessage($chat_id, 'همه پیام‌های آموزشی این محصول حذف شد.');
        adminShowProductMessages($chat_id, $product_id, $message_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'admin_delmsg_') === 0 && $is_admin) {
        $product_id = str_replace('admin_delmsg_', '', $data);
        sendMessage($chat_id, 'شماره پیام مورد نظر برای حذف را وارد کنید:', ["force_reply" => true]);
        file_put_contents("admin_delmsg_{$chat_id}.tmp", $product_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'admin_editmsg_') === 0 && $is_admin) {
        $product_id = str_replace('admin_editmsg_', '', $data);
        sendMessage($chat_id, 'شماره پیام مورد نظر برای ویرایش را وارد کنید:', ["force_reply" => true]);
        file_put_contents("admin_editmsg_{$chat_id}.tmp", $product_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif($data == 'admin_stats' && $is_admin) {
        $ustats = getUserStats();
        $order_count = getOrderStatsFromApi();
        $order_count_db = getOrderStatsFromDb();
        $msg = "📊 آمار ربات:\n";
        $msg .= "👤 کاربران امروز: {$ustats['today']}\n";
        $msg .= "👥 کاربران ماه: {$ustats['month']}\n";
        $msg .= "👥 کل کاربران: {$ustats['total']}\n";
        $msg .= "🛒 کل سفارشات سایت: {$order_count}\n";
        $msg .= "📦 آموزش‌های ارسال‌شده توسط ربات: {$order_count_db}";
        editMessage($chat_id, $message_id, $msg, [
            'inline_keyboard' => [
                [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_panel'] ]
            ]
        ]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif($data == 'check_join') {
        $channel = '@goldencheatir';
        $check = json_decode(file_get_contents(API_URL.'getChatMember?chat_id='.$channel.'&user_id='.$user_id), true);
        $status = $check['result']['status'] ?? '';
        if($status == 'member' || $status == 'administrator' || $status == 'creator') {
            sendMessage($chat_id, '✅ عضویت شما تایید شد. حالا می‌توانید از ربات استفاده کنید.');
        } else {
            $join_keyboard = [
                'inline_keyboard' => [
                    [ ['text' => 'عضویت در کانال', 'url' => 'https://t.me/goldencheatir'] ],
                    [ ['text' => 'بررسی عضویت ✅', 'callback_data' => 'check_join'] ]
                ]
            ];
            sendMessage($chat_id, "هنوز عضو کانال نشده‌اید! لطفاً ابتدا عضو شوید.", $join_keyboard);
        }
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif($data == 'admin_admins' && $user_id == ADMIN_ID) {
        $stmt = dbQuery("SELECT telegram_id FROM admins");
        $admins = $stmt->fetchAll();
        $text = "لیست ادمین‌های فعلی:\n";
        foreach($admins as $a) $text .= $a['telegram_id'] . "\n";
        $keyboard = [
            'inline_keyboard' => [
                [ ['text' => '➕ افزودن ادمین جدید', 'callback_data' => 'admin_addadmin'] ],
                [ ['text' => '➖ حذف ادمین', 'callback_data' => 'admin_deladmin'] ],
                [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_panel'] ],
            ]
        ];
        editMessage($chat_id, $message_id, $text, $keyboard);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif($data == 'admin_addadmin' && $user_id == ADMIN_ID) {
        sendMessage($chat_id, 'آیدی عددی ادمین جدید را ارسال کنید:', ["force_reply" => true]);
        file_put_contents("admin_addadmin_{$chat_id}.tmp", 1);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif($data == 'admin_deladmin' && $user_id == ADMIN_ID) {
        sendMessage($chat_id, 'آیدی عددی ادمینی که می‌خواهید حذف کنید را ارسال کنید:', ["force_reply" => true]);
        file_put_contents("admin_deladmin_{$chat_id}.tmp", 1);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'admin_orders_') === 0 && $is_admin) {
        $page = intval(str_replace('admin_orders_', '', $data));
        $per_page = 5;
        $offset = $page * $per_page;
        $url = "https://goldencheat.ir/wp-json/wc/v3/orders?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET . "&status=processing&orderby=date&order=desc&per_page=$per_page&offset=$offset";
        $response = @file_get_contents($url);
        $orders = json_decode($response, true);
        if(!$orders || !is_array($orders)) {
            sendMessage($chat_id, 'سفارشی یافت نشد یا ارتباط با سایت برقرار نشد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $text = "📋 لیست سفارشات جدید (صفحه " . ($page+1) . "):\n";
        foreach($orders as $i => $order) {
            $order_id = $order['id'];
            $name = $order['billing']['first_name'] . ' ' . $order['billing']['last_name'];
            $status = $order['status'];
            $text .= ($i+1) . ". #{$order_id} | {$name} | وضعیت: {$status}\n";
        }
        $text .= "\nبرای مشاهده جزئیات، شماره ردیف سفارش را ارسال کنید یا 'بازگشت' را بزنید.";
        $reply_keyboard = [
            'keyboard' => [
                [['text' => 'بازگشت']],
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
        editMessage($chat_id, $message_id, $text, $reply_keyboard);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'admin_orderdetail_') === 0 && $is_admin) {
        $order_id = str_replace('admin_orderdetail_', '', $data);
        $url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
        $response = @file_get_contents($url);
        $order = json_decode($response, true);
        file_put_contents('order_detail_debug.txt', print_r($order, true), FILE_APPEND);
        if(!$order || !isset($order['id'])) {
            editMessage($chat_id, $message_id, "سفارش یافت نشد یا ارتباط با سایت برقرار نشد.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $products = [];
        foreach($order['line_items'] as $item) {
            $products[] = $item['name'];
        }
        $products_str = implode('، ', $products);
        $status_map = [
            'processing' => 'در حال انجام',
            'completed' => 'تکمیل‌شده',
            'cancelled' => 'لغو شده',
            'refunded' => 'مسترد شده',
            'pending' => 'در انتظار پرداخت'
        ];
        $status_fa = $status_map[$order['status']] ?? $order['status'];
        // اگر وضعیت سفارش pending بود فقط پیام ساده ارسال شود
        if($order['status'] == 'pending') {
            $product_name = $products_str;
            $pending_text = "🔔 کاربری برای محصول \"{$product_name}\" به مرحله ی در انتظار پرداخت رفت.\nشماره سفارش: #{$order['id']}";
            editMessage($chat_id, $message_id, $pending_text);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // دریافت یادداشت‌ها
        $notes_url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}/notes?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
        $notes_response = @file_get_contents($notes_url);
        $notes = json_decode($notes_response, true);
        $notes_text = '';
        if ($notes && is_array($notes)) {
            $count = 0;
            foreach (array_slice($notes, -5) as $n) {
                $note = $n['note'];
                // حذف کاراکترهای کنترلی و محدود کردن طول
                $note = mb_substr(preg_replace('/[\x00-\x1F\x7F]/u', '', $note), 0, 200);
                $notes_text .= "• " . $note . "\n";
                $count++;
            }
            if ($count == 0) $notes_text = "یادداشتی ثبت نشده است.";
        } else {
            $notes_text = "یادداشتی ثبت نشده است.";
        }
        // دکمه‌های وضعیت با تیک
        $statuses = [
            'processing' => 'در حال انجام',
            'completed' => 'تکمیل‌شده',
            'cancelled' => 'لغو شده',
            'refunded' => 'مسترد شده',
            'pending' => 'در انتظار پرداخت'
        ];
        $status_buttons = [];
        foreach ($statuses as $key => $val) {
            $tick = ($order['status'] == $key) ? '✅ ' : '';
            $status_buttons[] = ['text' => $tick . $val, 'callback_data' => "admin_orderstatus_{$order_id}_{$key}"];
        }
        $text = "🔎 جزئیات سفارش #{$order['id']}\n";
        $text .= "تاریخ: " . ($order['date_created'] ?? '-') . "\n";
        $text .= "محصول(ها): {$products_str}\n";
        $text .= "قیمت: " . ($order['total'] ?? '-') . " تومان\n";
        $text .= "وضعیت: {$status_fa}\n";
        $text .= "نام خریدار: " . ($order['billing']['first_name'] . ' ' . $order['billing']['last_name']) . "\n";
        $text .= "ایمیل: " . ($order['billing']['email'] ?? '-') . "\n";
        $text .= "تلفن: " . ($order['billing']['phone'] ?? '-') . "\n";
        $text .= "➖➖➖یادداشت ها➖➖➖\n";
        $text .= $notes_text;
        
        $keyboard = [
            'inline_keyboard' => [
                [ ['text'=>'✏️ ارسال یادداشت برای کاربر','callback_data'=>'admin_ordernoteuser_'.$order_id], ['text'=>'✏️ فقط برای مدیر','callback_data'=>'admin_ordernoteadmin_'.$order_id] ],
                $status_buttons,
                [ ['text'=>'🔙 بازگشت','callback_data'=>'admin_orders_0'] ]
            ]
        ];
        editMessage($chat_id, $message_id, $text, $keyboard);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'admin_orderstatus_') === 0 && $is_admin) {
        $parts = explode('_', $data);
        $order_id = $parts[2];
        $new_status = $parts[3];
        $url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
        $payload = json_encode(['status' => $new_status]);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($payload)
        ]);
        $result = curl_exec($ch);
        curl_close($ch);
        sendMessage($chat_id, "وضعیت سفارش #{$order_id} با موفقیت به '{$new_status}' تغییر یافت.");
        // ارسال پیام به کاربر در صورت وجود شماره تماس
        $order = getOrderFromApi($order_id);
        $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
        if($order_mobile && strlen($order_mobile) === 11 && strpos($order_mobile, '09') === 0) {
            $stmt = dbQuery("SELECT telegram_id FROM users WHERE mobile = ?", [$order_mobile]);
            if($row = $stmt->fetch()) {
                $status_map = [
                    'processing' => 'در حال انجام',
                    'completed' => 'تکمیل‌شده',
                    'cancelled' => 'لغو شده',
                    'refunded' => 'مسترد شده',
                    'pending' => 'در انتظار پرداخت'
                ];
                $status_fa = $status_map[$new_status] ?? $new_status;
                sendMessage($row['telegram_id'], "وضعیت سفارش شما (#{$order_id}) به '{$status_fa}' تغییر یافت.");
            }
        }
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } elseif(isset($data) && strpos($data, 'admin_ordernoteuser_') === 0 && $is_admin) {
        $order_id = str_replace('admin_ordernoteuser_', '', $data);
        sendMessage($chat_id, 'متن یادداشت را وارد کنید (این یادداشت برای کاربر نمایش داده می‌شود):', ["force_reply" => true]);
        file_put_contents("admin_ordernote_{$chat_id}.tmp", json_encode(['order_id'=>$order_id,'is_user'=>true]));
    } elseif(isset($data) && strpos($data, 'admin_ordernoteadmin_') === 0 && $is_admin) {
        $order_id = str_replace('admin_ordernoteadmin_', '', $data);
        sendMessage($chat_id, 'متن یادداشت را وارد کنید (این یادداشت فقط برای مدیر ثبت می‌شود):', ["force_reply" => true]);
        file_put_contents("admin_ordernote_{$chat_id}.tmp", json_encode(['order_id'=>$order_id,'is_user'=>false]));
    } elseif(isset($data) && strpos($data, 'admin_ordernote_') === 0 && $is_admin) {
        $order_id = str_replace('admin_ordernote_', '', $data);
        sendMessage($chat_id, "متن یادداشت را ارسال کنید:\n(برای نمایش به کاربر، متن را با /user شروع کنید. برای یادداشت فقط مدیر، متن را بدون /user بنویسید)", ["force_reply" => true]);
        file_put_contents("admin_ordernote_{$chat_id}.tmp", $order_id);
    } elseif(isset($data) && strpos($data, 'admin_recentusers_') === 0 && $is_admin) {
        $page = intval(str_replace('admin_recentusers_', '', $data));
        $per_page = 10;
        $offset = $page * $per_page;
        $stmt = dbQuery("SELECT telegram_id, mobile, created_at FROM users WHERE mobile IS NOT NULL AND mobile != '' ORDER BY created_at DESC LIMIT $per_page OFFSET $offset");
        $users = $stmt->fetchAll();
        $text = '👤 ۱۰ کاربر اخیر ثبت‌نام‌شده:\n';
        foreach($users as $i => $u) {
            $mobile = $u['mobile'] ? $u['mobile'] : '---';
            $created = $u['created_at'];
            $text .= ($i+1) . ". {$mobile} | ثبت: {$created}\n";
        }
        $text .= "\nبرای مشاهده جزئیات، شماره ردیف کاربر را ارسال کنید یا 'بازگشت' را بزنید.";
        $reply_keyboard = [
            'keyboard' => [
                [['text' => 'بازگشت']],
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
        editMessage($chat_id, $message_id, $text, $reply_keyboard);
    } elseif(isset($data) && strpos($data, 'admin_userdetail_') === 0 && $is_admin) {
        $user_tg_id = str_replace('admin_userdetail_', '', $data);
        $stmt = dbQuery("SELECT mobile, created_at FROM users WHERE telegram_id = ?", [$user_tg_id]);
        $user = $stmt->fetch();
        if(!$user) {
            sendMessage($chat_id, 'کاربر یافت نشد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $mobile = $user['mobile'] ? $user['mobile'] : '---';
        $created = $user['created_at'];
        // شمارش تعداد سفارشات از ووکامرس
        $order_count = 0;
        if($mobile && $mobile !== '---') {
            $url = "https://goldencheat.ir/wp-json/wc/v3/orders?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET . "&status=processing,completed";
            $response = @file_get_contents($url);
            $orders = json_decode($response, true);
            if($orders && is_array($orders)) {
                foreach($orders as $order) {
                    $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
                    if($order_mobile == $mobile) $order_count++;
                }
            }
        }
        // بررسی وضعیت بن
        $stmt_bl = dbQuery("SELECT until FROM blacklist WHERE telegram_id = ?", [$user_tg_id]);
        $ban_info = $stmt_bl->fetch();
        $ban_text = '';
        $ban_btn = [];
        if($ban_info && strtotime($ban_info['until']) > time()) {
            $remain = strtotime($ban_info['until']) - time();
            $hours = floor($remain/3600);
            $mins = floor(($remain%3600)/60);
            $ban_text = "\n⛔️ کاربر تا ".date('Y-m-d H:i', strtotime($ban_info['until']))." بن است (".($hours>0?"{$hours} ساعت و ":'')."{$mins} دقیقه باقی مانده)";
            $ban_btn = [ ['text'=>'🔓 آزادسازی بن','callback_data'=>'admin_unban_'.$user_tg_id] ];
        }
        // دریافت کدهای تخفیف فعال کاربر از ووکامرس
        $coupons = [];
        if($mobile && $mobile !== '---') {
            $url = "https://goldencheat.ir/wp-json/wc/v3/coupons?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
            $response = @file_get_contents($url);
            $all_coupons = json_decode($response, true);
            if($all_coupons && is_array($all_coupons)) {
                foreach($all_coupons as $c) {
                    if(isset($c['description']) && strpos($c['description'], (string)$user_tg_id) !== false && (!isset($c['date_expires']) || strtotime($c['date_expires']) > time())) {
                        $coupons[] = $c;
                    }
                }
            }
        }
        $text = "👤 اطلاعات کاربر:\nشماره: {$mobile}\nتاریخ عضویت: {$created}\nتعداد سفارش: {$order_count}{$ban_text}";
        if($coupons) {
            $text .= "\n\n🎫 کدهای تخفیف فعال:";
            foreach($coupons as $c) {
                $exp = $c['date_expires'] ? date('Y-m-d', strtotime($c['date_expires'])) : 'نامحدود';
                $text .= "\n<b>{$c['code']}</b> | {$c['amount']}% | {$c['usage_limit']} بار | تا {$exp}";
            }
        }
        $keyboard = [
            'inline_keyboard' => [
                [ ['text'=>'📦 سفارشات کاربر','callback_data'=>'admin_userorders_'.$user_tg_id] ],
                [ ['text'=>'✉️ ارسال پیام شخصی','callback_data'=>'admin_usermsg_'.$user_tg_id] ],
                [ ['text'=>'🎁 ساخت کد تخفیف','callback_data'=>'admin_usercoupon_'.$user_tg_id] ],
                [ ['text'=>'⛔️ بن ساعتی','callback_data'=>'admin_userban_'.$user_tg_id] ],
            ]
        ];
        // دکمه حذف و ویرایش برای هر کد تخفیف
        if($coupons) {
            foreach($coupons as $c) {
                $keyboard['inline_keyboard'][] = [
                    ['text'=>'❌ حذف '.$c['code'],'callback_data'=>'admin_delcoupon_'.$c['id'].'_'.$user_tg_id],
                    ['text'=>'✏️ ویرایش '.$c['code'],'callback_data'=>'admin_editcoupon_'.$c['id'].'_'.$user_tg_id]
                ];
            }
        }
        if($ban_btn) $keyboard['inline_keyboard'][] = $ban_btn;
        $keyboard['inline_keyboard'][] = [ ['text'=>'🔙 بازگشت','callback_data'=>'admin_recentusers_0'] ];
        editMessage($chat_id, $message_id, $text, $keyboard);
    }
    // حذف کد تخفیف اختصاصی
    elseif(isset($data) && strpos($data, 'admin_delcoupon_') === 0 && $is_admin) {
        $parts = explode('_', str_replace('admin_delcoupon_','',$data),2);
        $coupon_id = $parts[0];
        $user_tg_id = $parts[1];
        $url = "https://goldencheat.ir/wp-json/wc/v3/coupons/{$coupon_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
        logAdminAction($user_id, 'delete_coupon', $user_tg_id, "coupon_id:{$coupon_id}");
        sendMessage($chat_id, 'کد تخفیف حذف شد.');
        // بازگشت به زیرمنوی کاربر
        $data = 'admin_userdetail_'.$user_tg_id;
        // اجرای مجدد زیرمنو
        // ... existing code ...
    }
    // ویرایش کد تخفیف اختصاصی
    elseif(isset($data) && strpos($data, 'admin_editcoupon_') === 0 && $is_admin) {
        $parts = explode('_', str_replace('admin_editcoupon_','',$data),2);
        $coupon_id = $parts[0];
        $user_tg_id = $parts[1];
        sendMessage($chat_id, 'درصد جدید، تعداد روز و دفعات استفاده را با کاما وارد کنید (مثال: 25,5,2):', ["force_reply" => true]);
        file_put_contents("admin_editcoupon_{$chat_id}.tmp", json_encode(['coupon_id'=>$coupon_id,'user_tg_id'=>$user_tg_id]));
    }
    // نمایش سفارشات کاربر (تکمیل‌شده و در حال انجام) با وضعیت و دکمه جزئیات
    elseif(isset($data) && strpos($data, 'admin_userorders_') === 0 && $is_admin) {
        $user_tg_id = str_replace('admin_userorders_', '', $data);
        $stmt = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_tg_id]);
        $user = $stmt->fetch();
        if(!$user || !$user['mobile']) {
            sendMessage($chat_id, 'شماره موبایل کاربر یافت نشد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $mobile = $user['mobile'];
        $url = "https://goldencheat.ir/wp-json/wc/v3/orders?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET . "&status=processing,completed";
        $response = @file_get_contents($url);
        $orders = json_decode($response, true);
        $user_orders = [];
        if($orders && is_array($orders)) {
            foreach($orders as $order) {
                $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
                if($order_mobile == $mobile) {
                    $user_orders[] = $order;
                }
            }
        }
        $keyboard = ['inline_keyboard'=>[]];
        $text = "📦 سفارشات کاربر (تکمیل‌شده و در حال انجام):\n";
        if($user_orders) {
            foreach($user_orders as $order) {
                $oid = $order['id'];
                $status_map = [
                    'processing' => 'در حال انجام',
                    'completed' => 'تکمیل‌شده',
                    'cancelled' => 'لغو شده',
                    'refunded' => 'مسترد شده',
                    'pending' => 'در انتظار پرداخت'
                ];
                $status_fa = $status_map[$order['status']] ?? $order['status'];
                $text .= "#{$oid} | وضعیت: {$status_fa}\n";
                $keyboard['inline_keyboard'][] = [
                    ['text' => "جزئیات سفارش #{$oid}", 'callback_data' => 'admin_orderdetail_' . $oid]
                ];
            }
        } else {
            $text .= "سفارشی یافت نشد.";
        }
        $keyboard['inline_keyboard'][] = [ ['text'=>'🔙 بازگشت','callback_data'=>'admin_userdetail_'.$user_tg_id] ];
        editMessage($chat_id, $message_id, $text, $keyboard);
    }
    // هندل callback_query برای سفارشات من
    if($data == 'my_orders') {
        // دریافت شماره موبایل کاربر
        $stmt = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
        $row = $stmt->fetch();
        if(!$row || !$row['mobile']) {
            sendMessage($chat_id, "برای مشاهده سفارشات، ابتدا شماره موبایل خود را ثبت کنید.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $mobile = $row['mobile'];
        // دریافت سفارشات از ووکامرس
        $url = "https://goldencheat.ir/wp-json/wc/v3/orders?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET . "&status=processing,completed,refunded";
        $response = @file_get_contents($url);
        $orders = json_decode($response, true);
        $user_orders = [];
        if($orders && is_array($orders)) {
            foreach($orders as $order) {
                $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
                if($order_mobile == $mobile) {
                    $user_orders[] = $order;
                }
            }
        }
        if(!$user_orders) {
            sendMessage($chat_id, "سفارشی برای شما یافت نشد.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // نمایش لیست سفارشات به صورت متنی
        $status_map = [
            'processing' => 'در حال انجام',
            'completed' => 'تکمیل‌شده',
            'refunded' => 'مسترد شده',
            'cancelled' => 'لغو شده',
            'pending' => 'در انتظار پرداخت'
        ];
        $text = "📋 لیست سفارشات شما:\n";
        $products = [];
        foreach($user_orders as $order) {
            $oid = $order['id'];
            $pname = $order['line_items'][0]['name'] ?? '-';
            $status_fa = $status_map[$order['status']] ?? $order['status'];
            $text .= "#{$oid} | {$pname} | وضعیت: {$status_fa}\n";
            // جمع‌آوری محصولات یکتا
            $pid = $order['line_items'][0]['product_id'] ?? null;
            if($pid) {
                if(!isset($products[$pid])) $products[$pid] = ['name'=>$pname, 'count'=>0];
                $products[$pid]['count']++;
            }
        }
        // دکمه‌های شیشه‌ای محصولات یکتا
        $inline = [];
        foreach($products as $pid => $info) {
            $inline[] = [ ['text' => '🎮 آموزش ' . $info['name'] . ($info['count']>1?' ('.$info['count'].' بار)':''), 'callback_data' => 'my_order_training_'.$pid] ];
        }
        $inline[] = [ ['text'=>'🔙 بازگشت','callback_data'=>'main_menu'] ];
        sendMessage($chat_id, $text, ['inline_keyboard'=>$inline]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // هندل دریافت آموزش هر محصول از سفارشات من
    if(strpos($data, 'my_order_training_') === 0) {
        $pid = str_replace('my_order_training_', '', $data);
        // دریافت شماره موبایل کاربر
        $stmt = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
        $row = $stmt->fetch();
        $mobile = $row ? $row['mobile'] : null;
        if($mobile) {
            sendProductTraining($chat_id, $pid, $mobile);
        } else {
            sendMessage($chat_id, "شماره موبایل شما یافت نشد. لطفاً ابتدا شماره موبایل خود را ثبت کنید.");
        }
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // هندل دریافت دوباره لایسنس
    if(strpos($data, 'user_get_license_') === 0) {
        $order_id = str_replace('user_get_license_', '', $data);
        // دریافت شماره موبایل کاربر
        $stmt = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
        $row = $stmt->fetch();
        $mobile = $row ? normalizeMobile($row['mobile']) : null;
        if(!$mobile) {
            sendMessage($chat_id, "شماره موبایل شما یافت نشد.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // دریافت سفارش از API
        $order = getOrderFromApi($order_id);
        if(!$order) {
            sendMessage($chat_id, "سفارش یافت نشد.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // بررسی مطابقت شماره موبایل
        $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
        if($order_mobile !== $mobile) {
            sendMessage($chat_id, "شماره موبایل شما با سفارش مطابقت ندارد.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // جستجوی لایسنس
        $license_found = false;
        $license_key = null;
        foreach($order['line_items'] as $item) {
            $product_id = $item['product_id'] ?? null;
            $variation_id = $item['variation_id'] ?? 0;
            if($product_id && $variation_id) {
                $stmt_lic = dbQuery("SELECT license_key FROM licenses WHERE product_id = ? AND variation_id = ? AND assigned_to_order = ? AND assigned_to_user = ?", [$product_id, $variation_id, $order_id, $mobile]);
                if($lic = $stmt_lic->fetch()) {
                    $license_key = $lic['license_key'];
                    $license_found = true;
                    break;
                }
            }
        }
        if($license_found) {
            $license_msg = "🚨 خبر داغ از گلدن چیت 🍾\n🎩 ساقی انواع چیت‌های ارجینال رسید خدمتتون 😌💼\n💉 دوز مخصوص امروز: لایسنس چیت خفن شما!\n\n🎮 🔑 <code>{$license_key}</code> 🔑 🎮\n\n🔥 با احتیاط مصرف شَوَد؛ ممکنه اعتیاد پیدا بکنی 😈😂\nاگه مشکلی بود، ساقی همیشه آنلاینه 💬📲";
            sendMessage($chat_id, $license_msg);
        } else {
            sendMessage($chat_id, "⚠️ متأسفانه لایسنس برای این سفارش یافت نشد. لطفاً با پشتیبانی تماس بگیرید.");
        }
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // هندل نمایش لایسنس و آموزش هر سفارش
    if(strpos($data, 'my_license_order_') === 0) {
        $order_id = str_replace('my_license_order_', '', $data);
        // دریافت شماره موبایل کاربر
        $stmt = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
        $row = $stmt->fetch();
        $mobile = $row ? normalizeMobile($row['mobile']) : null;
        if(!$mobile) {
            sendMessage($chat_id, "شماره موبایل شما یافت نشد.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // دریافت سفارش از API
        $order = getOrderFromApi($order_id);
        if(!$order) {
            sendMessage($chat_id, "سفارش یافت نشد.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // بررسی مطابقت شماره موبایل
        $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
        if($order_mobile !== $mobile) {
            sendMessage($chat_id, "شماره موبایل شما با سفارش مطابقت ندارد.");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // جستجوی لایسنس
        $license_found = false;
        $license_key = null;
        $product_name = $order['line_items'][0]['name'] ?? 'نامشخص';
        foreach($order['line_items'] as $item) {
            $product_id = $item['product_id'] ?? null;
            $variation_id = $item['variation_id'] ?? 0;
            if($product_id && $variation_id) {
                $stmt_lic = dbQuery("SELECT license_key FROM licenses WHERE product_id = ? AND variation_id = ? AND assigned_to_order = ? AND assigned_to_user = ?", [$product_id, $variation_id, $order_id, $mobile]);
                if($lic = $stmt_lic->fetch()) {
                    $license_key = $lic['license_key'];
                    $license_found = true;
                    break;
                }
            }
        }
        $status_map = [
            'processing' => 'در حال انجام',
            'completed' => 'تکمیل‌شده',
            'refunded' => 'مسترد شده',
            'cancelled' => 'لغو شده',
            'pending' => 'در انتظار پرداخت'
        ];
        $status_fa = $status_map[$order['status']] ?? $order['status'];
        $order_text = "📦 <b>جزئیات سفارش #{$order_id}</b>\n\n";
        $order_text .= "محصول: {$product_name}\n";
        $order_text .= "وضعیت: {$status_fa}\n";
        $order_text .= "تاریخ: " . date('Y-m-d H:i', strtotime($order['date_created'])) . "\n\n";
        if($license_found) {
            $order_text .= "🔑 <b>لایسنس شما:</b>\n";
            $order_text .= "🎮 🔑 <code>{$license_key}</code> 🔑 🎮\n\n";
        } else {
            $order_text .= "⚠️ لایسنس برای این سفارش یافت نشد.\n\n";
        }
        $inline_keyboard = [];
        if($license_found) {
            $inline_keyboard[] = [['text' => '🔑 دریافت دوباره لایسنس', 'callback_data' => 'user_get_license_' . $order_id]];
        }
        $inline_keyboard[] = [['text' => '🎓 دریافت آموزش', 'callback_data' => 'my_order_training_' . $order_id]];
        $inline_keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => 'main_menu']];
        editMessage($chat_id, $message_id, $order_text, ['inline_keyboard' => $inline_keyboard]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    if(isset($update['callback_query']) && isset($update['callback_query']['data'])) {
        $data = $update['callback_query']['data'];
        $chat_id = $update['callback_query']['message']['chat']['id'];
        $user_id = $update['callback_query']['from']['id'];
        $is_admin = ($user_id == ADMIN_ID) || dbQuery("SELECT telegram_id FROM admins WHERE telegram_id = ?", [$user_id])->fetch();

        // --- هندل سریع دکمه‌های لایسنس آزاد (در ابتدای بلاک) ---
        if(strpos($data, 'send_free_license_') === 0 && $is_admin) {
            $order_id = str_replace('send_free_license_', '', $data);
            $url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
            $order = json_decode(@file_get_contents($url), true);
            if(!$order || !isset($order['id'])) {
                sendMessage($chat_id, "سفارش یافت نشد یا ارتباط با سایت برقرار نشد.");
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            $product_id = $order['line_items'][0]['product_id'] ?? null;
            $variation_id = $order['line_items'][0]['variation_id'] ?? null;
            $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
            $stmt_check = dbQuery("SELECT id FROM licenses WHERE product_id = ? AND variation_id = ? AND assigned_to_order = ? AND status = 'assigned'", [$product_id, $variation_id, $order_id]);
            if($stmt_check->fetch()) {
                sendMessage($chat_id, '❗️ برای این سفارش قبلاً لایسنس اختصاص داده شده است.');
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            if($product_id && $variation_id && $order_mobile) {
                $stmt = dbQuery("SELECT id, license_key FROM licenses WHERE product_id = ? AND variation_id = ? AND status = 'free' LIMIT 1", [$product_id, $variation_id]);
                if($lic = $stmt->fetch()) {
                    dbQuery("UPDATE licenses SET status = 'assigned', assigned_to_order = ?, assigned_to_user = ?, assigned_at = NOW() WHERE id = ?", [$order_id, $order_mobile, $lic['id']]);
                    
                    // افزودن یادداشت به سفارش در ووکامرس
                    $note = "لایسنس شما: {$lic['license_key']}";
                    $url_note = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}/notes?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
                    $payload = json_encode([
                        'note' => $note,
                        'customer_note' => true
                    ]);
                    $ch = curl_init($url_note);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, [
                        'Content-Type: application/json',
                        'Content-Length' => strlen($payload)
                    ]);
                    curl_exec($ch);
                    curl_close($ch);
                    
                    // تغییر وضعیت سفارش به completed
                    $url_status = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
                    $status_payload = json_encode(['status' => 'completed']);
                    $ch_status = curl_init($url_status);
                    curl_setopt($ch_status, CURLOPT_CUSTOMREQUEST, 'PUT');
                    curl_setopt($ch_status, CURLOPT_POSTFIELDS, $status_payload);
                    curl_setopt($ch_status, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch_status, CURLOPT_HTTPHEADER, [
                        'Content-Type: application/json',
                        'Content-Length' => strlen($status_payload)
                    ]);
                    curl_exec($ch_status);
                    curl_close($ch_status);
                    
                    $msg = "🚨 خبر داغ از گلدن چیت 🍾\n🎩 ساقی انواع چیت‌های ارجینال رسید خدمتتون 😌💼\n💉 دوز مخصوص امروز: لایسنس چیت خفن شما!\n\n🎮 🔑 <code>{$lic['license_key']}</code> 🔑 🎮\n\n🔥 با احتیاط مصرف شَوَد؛ ممکنه اعتیاد پیدا بکنی 😈😂\nاگه مشکلی بود، ساقی همیشه آنلاینه 💬📲";
                    $stmt_user = dbQuery("SELECT telegram_id FROM users WHERE mobile = ?", [$order_mobile]);
                    if($row = $stmt_user->fetch()) {
                        sendMessage($row['telegram_id'], $msg);
                    }
                    sendMessage($chat_id, '✅ لایسنس آزاد با موفقیت برای کاربر ارسال و ثبت شد و وضعیت سفارش به تکمیل شده تغییر کرد.');
                } else {
                    sendMessage($chat_id, '❗️ لایسنس آزاد موجود نیست یا قبلاً اختصاص داده شده است.');
                }
            } else {
                sendMessage($chat_id, '❗️ اطلاعات سفارش یا کاربر ناقص است.');
            }
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        if(strpos($data, 'free_license_count_') === 0 && $is_admin) {
            $order_id = str_replace('free_license_count_', '', $data);
            $url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
            $order = json_decode(@file_get_contents($url), true);
            if(!$order || !isset($order['id'])) {
                sendMessage($chat_id, "سفارش یافت نشد یا ارتباط با سایت برقرار نشد.");
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            $product_id = $order['line_items'][0]['product_id'] ?? null;
            $variation_id = $order['line_items'][0]['variation_id'] ?? null;
            $free_license_count = 0;
            if($product_id && $variation_id) {
                $stmt = dbQuery("SELECT COUNT(*) as cnt FROM licenses WHERE product_id = ? AND variation_id = ? AND status = 'free'", [$product_id, $variation_id]);
                $row = $stmt->fetch();
                $free_license_count = $row ? intval($row['cnt']) : 0;
            }
            sendMessage($chat_id, "تعداد موجودی = {$free_license_count} عدد");
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }

        if(strpos($data, 'admin_manageorder_') === 0 && $is_admin) {
            $order_id = str_replace('admin_manageorder_', '', $data);
            // نمایش جزئیات و منوی مدیریت همان سفارش (کد نمایش جزئیات سفارش را فراخوانی کن)
            $url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
            $order = json_decode(@file_get_contents($url), true);
            if(!$order || !isset($order['id'])) {
                sendMessage($chat_id, "سفارش یافت نشد یا ارتباط با سایت برقرار نشد.");
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            $products = [];
            foreach($order['line_items'] as $item) {
                $products[] = $item['name'];
            }
            $products_str = implode('، ', $products);
            $status_map = [
                'processing' => 'در حال انجام',
                'completed' => 'تکمیل‌شده',
                'refunded' => 'مسترد شده',
                'pending' => 'در انتظار پرداخت'
            ];
            $status_fa = $status_map[$order['status']] ?? $order['status'];
            $text_detail = "🔎 جزئیات سفارش #{$order['id']}\n";
            $text_detail .= "تاریخ: " . ($order['date_created'] ?? '-') . "\n";
            $text_detail .= "محصول(ها): {$products_str}\n";
            $text_detail .= "قیمت: " . ($order['total'] ?? '-') . " تومان\n";
            $text_detail .= "وضعیت: {$status_fa}\n";
            $text_detail .= "نام خریدار: " . ($order['billing']['first_name'] . ' ' . $order['billing']['last_name']) . "\n";
            $text_detail .= "ایمیل: " . ($order['billing']['email'] ?? '-') . "\n";
            $text_detail .= "تلفن: " . ($order['billing']['phone'] ?? '-') . "\n";
            // دکمه‌های وضعیت سفارش + دکمه یادداشت
            $status_buttons = [];
            foreach($status_map as $key => $val) {
                $tick = ($order['status'] == $key) ? '✅ ' : '';
                $status_buttons[] = [['text' => $tick . $val . ($key=='processing'?' 🟡':($key=='completed'?' 🟢':($key=='refunded'?' 🔴':' ⏳'))),]];
            }
            $status_buttons[] = [['text' => '📝 اضافه کردن یادداشت برای کاربر']];
            $status_buttons[] = [['text' => '🚀 ارسال لایسنس به کاربر', 'callback_data' => 'admin_sendlicense_' . $order['id']]];
            $status_buttons[] = [['text' => '🔙 بازگشت']];
            $reply_keyboard = [
                'keyboard' => $status_buttons,
                'resize_keyboard' => true,
                'one_time_keyboard' => false
            ];
            sendMessage($chat_id, $text_detail . "\nبرای تغییر وضعیت یا افزودن یادداشت، یکی از دکمه‌های زیر را انتخاب کنید.", $reply_keyboard);
            file_put_contents("admin_selected_order_{$chat_id}.tmp", $order_id);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
    }
    // اینجا اضافه شود:
    elseif(strpos($data, 'admin_sendlicense_') === 0 && $is_admin) {
        $order_id = str_replace('admin_sendlicense_', '', $data);
        sendMessage($chat_id, 'فقط لایسنس را به صورت متنی ارسال کنید (بدون هیچ توضیحی):', ["force_reply" => true]);
        file_put_contents("admin_sendlicense_{$chat_id}.tmp", $order_id);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // هندل خرید چیت - انتخاب محصول
    if(isset($data) && strpos($data, 'buy_product_') === 0) {
        $product_id = str_replace('buy_product_', '', $data);
        // دریافت متغیرهای محصول از ووکامرس
        $vars = getProductVariationsFromApi($product_id);
        if(!$vars || !is_array($vars) || count($vars) == 0) {
            sendMessage($chat_id, 'برای این محصول متغیری جهت انتخاب وجود ندارد یا محصول قابل خرید نیست.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // مرحله اول انتخاب ویژگی (attribute)
        $attributes = $vars[0]['attributes'] ?? [];
        if(!$attributes) {
            sendMessage($chat_id, 'برای این محصول متغیری جهت انتخاب وجود ندارد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // ذخیره انتخاب محصول و مرحله خرید
        file_put_contents("buy_step_{$user_id}.tmp", json_encode(['product_id'=>$product_id, 'step'=>0, 'selected'=>[]]));
        // نمایش اولین ویژگی برای انتخاب
        $attr = $attributes[0]['name'];
        $options = [];
        foreach($vars as $v) {
            foreach($v['attributes'] as $a) {
                if($a['name'] == $attr && !in_array($a['option'], $options)) $options[] = $a['option'];
            }
        }
        $inline = [];
        foreach($options as $opt) {
            $inline[] = [ ['text'=>urldecode($opt), 'callback_data'=>'buy_attr_'.$product_id.'_0_'.urlencode($opt)] ];
        }
        $inline[] = [ ['text'=>'🔙 بازگشت','callback_data'=>'main_menu'] ];
        sendMessage($chat_id, "لطفاً گزینه مورد نظر برای '$attr' را انتخاب کنید:", ['inline_keyboard'=>$inline]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // هندل انتخاب مرحله‌ای متغیرهای محصول (دکمه معمولی)
    if(isset($data) && strpos($data, 'buy_attr_') === 0) {
        $parts = explode('_', $data, 5);
        $product_id = $parts[2];
        $step = intval($parts[3]);
        $selected = isset($parts[4]) ? urldecode($parts[4]) : '';
        $buy_file = "buy_step_{$user_id}.tmp";
        $buy_data = @json_decode(@file_get_contents($buy_file), true);
        if(!$buy_data) { sendMessage($chat_id, 'خطا در روند خرید. لطفاً مجدداً تلاش کنید.'); return; }
        $buy_data['selected'][] = trim($selected);
        $buy_data['step'] = $step+1;
        // دریافت متغیرهای محصول
        $vars = getProductVariationsFromApi($product_id);
        if(!$vars || !is_array($vars) || count($vars) == 0) {
            sendMessage($chat_id, 'محصول یا متغیرهای آن یافت نشد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // دریافت نام محصول
        $products = getProductsFromApi();
        $product_name = '';
        foreach($products as $p) if($p['id'] == $product_id) $product_name = $p['name'];
        // بررسی مرحله بعدی
        $attributes = $vars[0]['attributes'] ?? [];
        if($buy_data['step'] < count($attributes)) {
            $attr = $attributes[$buy_data['step']]['name'];
            $options = [];
            foreach($vars as $v) {
                $match = true;
                // مقایسه بر اساس نام ویژگی به جای اندیس
                for($i=0;$i<count($buy_data['selected']);$i++) {
                    $attr_name = $attributes[$i]['name'];
                    $found = false;
                    foreach($v['attributes'] as $va) {
                        if($va['name'] == $attr_name) {
                            // نرمال‌سازی برای مقایسه بهتر - حذف فاصله‌های اضافی و یکسان‌سازی
                            $selected_clean = trim(preg_replace('/\s+/', ' ', $buy_data['selected'][$i]));
                            $option_clean = trim(preg_replace('/\s+/', ' ', $va['option']));
                            // نرمال‌سازی کاراکترهای خاص (تبدیل + به + برای مقایسه)
                            $selected_clean = str_replace(['+', '&plus;'], '+', $selected_clean);
                            $option_clean = str_replace(['+', '&plus;'], '+', $option_clean);
                            // مقایسه با در نظر گیری کاراکترهای خاص
                            if($option_clean !== $selected_clean) {
                                $match = false;
                            }
                            $found = true;
                            break;
                        }
                    }
                    if(!$found) $match = false;
                }
                if($match) {
                    foreach($v['attributes'] as $a) {
                        if($a['name'] == $attr && !in_array($a['option'], $options)) $options[] = $a['option'];
                    }
                }
            }
            if(empty($options)) {
                sendMessage($chat_id, '⚠️ برای این انتخاب، گزینه‌ای یافت نشد. لطفاً از دکمه بازگشت استفاده کنید و دوباره تلاش کنید.');
                @unlink($buy_file);
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            $reply_keyboard = [
                'keyboard' => [],
                'resize_keyboard' => true,
                'one_time_keyboard' => true
            ];
            foreach($options as $opt) {
                // نمایش مستقیم گزینه بدون urldecode چون از API مستقیماً می‌آید
                $reply_keyboard['keyboard'][] = [ ['text'=>$opt] ];
            }
            $reply_keyboard['keyboard'][] = [ ['text'=>'🔙 بازگشت'] ];
            file_put_contents($buy_file, json_encode($buy_data));
            sendMessage($chat_id, "📦 $product_name\nلطفاً گزینه مورد نظر برای '$attr' را انتخاب کنید:", $reply_keyboard);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        } else {
            // مرحله آخر: پیدا کردن متغیر نهایی و نمایش قیمت
            $final_var = null;
            foreach($vars as $v) {
                $match = true;
                // مقایسه بر اساس نام ویژگی به جای اندیس
                for($i=0;$i<count($buy_data['selected']);$i++) {
                    $attr_name = $attributes[$i]['name'];
                    $found = false;
                    foreach($v['attributes'] as $va) {
                        if($va['name'] == $attr_name) {
                            // نرمال‌سازی برای مقایسه بهتر - حذف فاصله‌های اضافی و یکسان‌سازی
                            $selected_clean = trim(preg_replace('/\s+/', ' ', $buy_data['selected'][$i]));
                            $option_clean = trim(preg_replace('/\s+/', ' ', $va['option']));
                            // نرمال‌سازی کاراکترهای خاص (تبدیل + به + برای مقایسه)
                            $selected_clean = str_replace(['+', '&plus;'], '+', $selected_clean);
                            $option_clean = str_replace(['+', '&plus;'], '+', $option_clean);
                            // مقایسه با در نظر گیری کاراکترهای خاص
                            if($option_clean !== $selected_clean) {
                                $match = false;
                            }
                            $found = true;
                            break;
                        }
                    }
                    if(!$found) $match = false;
                }
                if($match) { $final_var = $v; break; }
            }
            if(!$final_var) { 
                // بررسی دقیق خطا
                $error_details = [];
                $error_details[] = "❌ متغیر انتخابی یافت نشد";
                $error_details[] = "📦 Product ID: " . ($product_id ?? 'نامشخص');
                $error_details[] = "📊 تعداد متغیرها: " . (isset($vars) && is_array($vars) ? count($vars) : 'نامشخص');
                
                if(isset($buy_data['selected']) && is_array($buy_data['selected'])) {
                    $error_details[] = "📋 انتخاب‌های کاربر: " . implode(', ', $buy_data['selected']);
                }
                
                if(isset($vars) && is_array($vars) && count($vars) > 0) {
                    $error_details[] = "\n📋 متغیرهای موجود:";
                    foreach(array_slice($vars, 0, 3) as $idx => $v) {
                        $attrs = [];
                        if(isset($v['attributes']) && is_array($v['attributes'])) {
                            foreach($v['attributes'] as $a) {
                                if(isset($a['name']) && isset($a['option'])) {
                                    $attrs[] = "{$a['name']}: {$a['option']}";
                                }
                            }
                        }
                        $error_details[] = "  " . ($idx + 1) . ". " . implode(' | ', $attrs);
                    }
                    if(count($vars) > 3) {
                        $error_details[] = "  ... و " . (count($vars) - 3) . " متغیر دیگر";
                    }
                } else {
                    $error_details[] = "\n❌ هیچ متغیری دریافت نشد";
                    $error_details[] = "📁 بررسی فایل cache: " . (file_exists(__DIR__ . "/product_vars_cache_{$product_id}.json") ? 'موجود' : 'وجود ندارد');
                }
                
                $error_msg = "⚠️ خطا در پیدا کردن متغیر:\n\n" . implode("\n", $error_details);
                sendMessage($chat_id, $error_msg);
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return; 
            }
            $price = $final_var['price'] ?? 'نامشخص';
            $variation_id = $final_var['id'] ?? 0;
            
            // بررسی تخفیف خرید مجدد
            $user_stmt = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
            $user_row = $user_stmt->fetch();
            $user_mobile = $user_row ? $user_row['mobile'] : '';
            
            $discount_info = null;
            $discounted_price = $price;
            $has_discount = false;
            
            // بررسی وجود تخفیف فعال برای این محصول/ویژگی
            if($user_mobile && strlen($user_mobile) >= 10) {
                $discount_check = getRepeatPurchaseDiscount($product_id, $variation_id);
                if($discount_check && (int)$discount_check['is_active'] == 1) {
                    try {
                        $eligibility = checkUserEligibleForDiscount($user_mobile, $product_id, $variation_id);
                        if($eligibility && isset($eligibility['eligible']) && $eligibility['eligible'] === true) {
                            $has_discount = true;
                            $discount_info = $eligibility['discount'];
                            $discounted_price = calculateDiscountedPrice($price, $discount_info['discount_percent']);
                        }
                    } catch (Exception $e) {
                        // در صورت خطا، تخفیف اعمال نمی‌شود
                        error_log("Error checking discount eligibility for user {$user_id} (mobile: {$user_mobile}, product: {$product_id}, variation: {$variation_id}): " . $e->getMessage());
                    }
                }
            }
            
            // ساخت پیام زیبا و حرفه‌ای با ایموجی
            $summary = "";
            
            // اگر تخفیف اعمال شده، پیام تبریک
            if($has_discount && $discount_info) {
                $custom_msg = '';
                $has_vip_header = false;
                $has_vip_price = false;
                
                if($discount_info['custom_message'] && trim($discount_info['custom_message']) != '') {
                    // بررسی و حذف متن‌های تکراری از پیام سفارشی
                    $custom_msg = $discount_info['custom_message'];
                    
                    // بررسی وجود "VIP MODE ACTIVATED"
                    if(preg_match('/✨👑.*?VIP.*?MODE.*?ACTIVATED.*?👑✨/is', $custom_msg)) {
                        $has_vip_header = true;
                        $custom_msg = preg_replace('/✨👑.*?VIP.*?MODE.*?ACTIVATED.*?👑✨/is', '', $custom_msg);
                    }
                    
                    // بررسی وجود "قیمت مخصوص VIP"
                    if(preg_match('/💫.*?قیمت.*?مخصوص.*?VIP.*?👇/is', $custom_msg)) {
                        $has_vip_price = true;
                        $custom_msg = preg_replace('/💫.*?قیمت.*?مخصوص.*?VIP.*?👇/is', '', $custom_msg);
                    }
                    
                    $custom_msg = preg_replace('/\n{3,}/', "\n\n", $custom_msg); // حذف خطوط خالی اضافی
                    $custom_msg = trim($custom_msg);
                }
                
                // اضافه کردن هدر VIP فقط اگر در پیام سفارشی نبود
                if(!$has_vip_header) {
                    $summary .= "✨👑 <b>VIP MODE ACTIVATED</b> 👑✨\n\n";
                }
                
                // اضافه کردن پیام سفارشی یا پیش‌فرض
                if($custom_msg) {
                    $summary .= $custom_msg . "\n\n";
                } else {
                    $summary .= "به‌خاطر سابقه خریدت، GoldenCheat همین الان یه تخفیف طلایی فوق‌ویژه برات باز کرد!\n\n";
                    $summary .= "این امتیاز مخصوص کاربرای خاصه… و تو یکی از اونایی! 💛🔥\n\n";
                }
                
                // اضافه کردن "قیمت مخصوص VIP" فقط اگر در پیام سفارشی نبود
                if(!$has_vip_price) {
                    $summary .= "💫 قیمت مخصوص VIP الان برات زده میشه 👇\n\n";
                }
                
                $summary .= "━━━━━━━━━━━━━━━━━━\n\n";
            }
            
            $summary .= "🛍️ <b>جزئیات سفارش شما</b>\n\n";
            $summary .= "📦 <b>محصول:</b> {$product_name}\n";
            $summary .= "━━━━━━━━━━━━━━━━━━\n";
            foreach($final_var['attributes'] as $a) {
                // تبدیل نام ویژگی به ایموجی مناسب
                $attr_emoji = '';
                if(strpos($a['name'], 'نوع') !== false) {
                    $attr_emoji = '⚙️';
                } elseif(strpos($a['name'], 'زمان') !== false || strpos($a['name'], 'مدت') !== false) {
                    $attr_emoji = '⏰';
                } elseif(strpos($a['name'], 'ورژن') !== false) {
                    $attr_emoji = '🔖';
                } else {
                    $attr_emoji = '📌';
                }
                $summary .= "{$attr_emoji} <b>{$a['name']}:</b> {$a['option']}\n";
            }
            $summary .= "━━━━━━━━━━━━━━━━━━\n";
            
            // نمایش قیمت با توجه به تخفیف
            if($has_discount && $discount_info) {
                $summary .= "💰 <b>قیمت اصلی:</b> <code>".number_format($price)." تومان</code>\n";
                $summary .= "🎁 <b>تخفیف ({$discount_info['discount_percent']}%):</b> <code>-".number_format($price - $discounted_price)." تومان</code>\n";
                $summary .= "━━━━━━━━━━━━━━━━━━\n";
                $summary .= "✅ <b>مبلغ قابل پرداخت (با تخفیف):</b> <code>".number_format($discounted_price)." تومان</code>\n\n";
            } else {
                $summary .= "💰 <b>مبلغ قابل پرداخت:</b> <code>".number_format($price)." تومان</code>\n\n";
            }
            
            $summary .= "💳 <b>اطلاعات پرداخت:</b>\n";
            $summary .= "━━━━━━━━━━━━━━━━━━\n";
            $summary .= "🔢 <b>شماره کارت:</b> <code>6219861907849813</code>\n";
            $summary .= "👤 <b>نام دارنده کارت:</b> مهدی دلال زاده احمدی\n\n";
            
            if($has_discount && $discount_info) {
                $summary .= "💸 <b>لطفاً مبلغ <code>".number_format($discounted_price)." تومان</code> را واریز کنید.</b>\n\n";
            }
            
            $summary .= "📸 لطفاً پس از واریز مبلغ، عکس رسید پرداخت را ارسال کنید.\n";
            $summary .= "⏳ پس از تایید پرداخت، لایسنس و آموزش برای شما ارسال خواهد شد.";
            
            // ذخیره قیمت با تخفیف در فایل
            file_put_contents($buy_file, json_encode([
                'product_id'=>$product_id, 
                'variation_id'=>$variation_id, 
                'price'=>$price, 
                'discounted_price'=>$discounted_price,
                'has_discount'=>$has_discount,
                'discount_percent'=>$has_discount ? $discount_info['discount_percent'] : 0,
                'summary'=>$summary, 
                'step'=>'upload_receipt'
            ]));
            sendMessage($chat_id, $summary);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
    }
    // تایید یا عدم تایید پرداخت توسط ادمین
    if(isset($data) && strpos($data, 'buy_confirm_') === 0 && $is_admin) {
        $target_id = str_replace('buy_confirm_', '', $data);
        $buy_file = "buy_step_{$target_id}.tmp";
        $buy_data = @json_decode(@file_get_contents($buy_file), true);
        if(!$buy_data) { sendMessage($chat_id, 'اطلاعات سفارش یافت نشد یا قبلاً تایید شده است.'); return; }
        // حذف پیام رسید پرداخت برای همه ادمین‌ها
        $stmt_admins = dbQuery("SELECT telegram_id FROM admins");
        while($row = $stmt_admins->fetch()) {
            $admin_id = $row['telegram_id'];
            // حذف پیام عکس رسید (پیام قبلی)
            if(isset($update['callback_query']['message']['message_id'])) {
                deleteMessage($admin_id, $update['callback_query']['message']['message_id']);
            }
        }
        // ثبت سفارش در ووکامرس
        $user_stmt = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$target_id]);
        $user = $user_stmt->fetch();
        $mobile = $user ? $user['mobile'] : '';
        $order_payload = [
            'payment_method' => 'bacs',
            'payment_method_title' => 'کارت به کارت',
            'set_paid' => true,
            'billing' => [
                'first_name' => 'کارت به کارت',
                'last_name' => '',
                'phone' => $mobile,
                'email' => 'user' . $target_id . '@noemail.com'
            ],
            'line_items' => [
                [
                    'product_id' => $buy_data['product_id'],
                    'variation_id' => $buy_data['variation_id'],
                    'quantity' => 1
                ]
            ]
        ];
        $url = "https://goldencheat.ir/wp-json/wc/v3/orders?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($order_payload));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen(json_encode($order_payload))
        ]);
        $result = curl_exec($ch);
        curl_close($ch);
        $order = json_decode($result, true);
        // لاگ خطا در ثبت سفارش
        if(!isset($order['id'])) {
            file_put_contents('order_api_error.log', date('Y-m-d H:i:s')."\n".$result."\n\n", FILE_APPEND);
        }
        if(isset($order['id'])) {
            $order_id = $order['id'];
            $product_id = $buy_data['product_id'];
            $variation_id = $buy_data['variation_id'];
            $mobile_norm = normalizeMobile($mobile);
            
            // تلاش برای تخصیص خودکار لایسنس
            $license_sent = false;
            $license_key = null;
            $stmt_lic = dbQuery("SELECT * FROM licenses WHERE product_id = ? AND variation_id = ? AND status = 'free' LIMIT 1", [$product_id, $variation_id]);
            if($lic = $stmt_lic->fetch()) {
                // تخصیص لایسنس
                dbQuery("UPDATE licenses SET status = 'assigned', assigned_to_order = ?, assigned_to_user = ?, assigned_at = NOW() WHERE id = ?", [$order_id, $mobile_norm, $lic['id']]);
                $license_key = $lic['license_key'];
                $license_sent = true;
                
                // افزودن یادداشت لایسنس به سفارش در ووکامرس
                $note = "لایسنس شما: {$license_key}";
                $url_note = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}/notes?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
                $payload_note = json_encode([
                    'note' => $note,
                    'customer_note' => true
                ]);
                $ch_note = curl_init($url_note);
                curl_setopt($ch_note, CURLOPT_POST, 1);
                curl_setopt($ch_note, CURLOPT_POSTFIELDS, $payload_note);
                curl_setopt($ch_note, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch_note, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($payload_note)
                ]);
                curl_exec($ch_note);
                curl_close($ch_note);
                
                // ارسال لایسنس به کاربر
                $license_msg = "🚨 خبر داغ از گلدن چیت 🍾\n🎩 ساقی انواع چیت‌های ارجینال رسید خدمتتون 😌💼\n💉 دوز مخصوص امروز: لایسنس چیت خفن شما!\n\n🎮 🔑 <code>{$license_key}</code> 🔑 🎮\n\n🔥 با احتیاط مصرف شَوَد؛ ممکنه اعتیاد پیدا بکنی 😈😂\nاگه مشکلی بود، ساقی همیشه آنلاینه 💬📲";
                sendMessage($target_id, $license_msg);
                
                // تغییر وضعیت سفارش به completed
                $url_status = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
                $status_payload = json_encode(['status' => 'completed']);
                $ch_status = curl_init($url_status);
                curl_setopt($ch_status, CURLOPT_CUSTOMREQUEST, 'PUT');
                curl_setopt($ch_status, CURLOPT_POSTFIELDS, $status_payload);
                curl_setopt($ch_status, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch_status, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($status_payload)
                ]);
                curl_exec($ch_status);
                curl_close($ch_status);
                
                // ارسال خودکار آموزش
                if(function_exists('sendProductTraining')) {
                    sendProductTraining($target_id, $order_id, $mobile);
                }
            }
            
            // دریافت نام محصول برای پیام
            $products_api = getProductsFromApi();
            $product_name = '';
            foreach($products_api as $p) {
                if($p['id'] == $product_id) {
                    $product_name = $p['name'];
                    break;
                }
            }
            
            // ارسال پیام به کاربر
            if($license_sent) {
                $user_msg = "🎉 سفارش شما با موفقیت ثبت شد!\n\nشماره سفارش: #{$order_id}\nمحصول: {$product_name}";
                $inline_keyboard = [
                    'inline_keyboard' => [
                        [['text' => '🔑 دریافت دوباره لایسنس', 'callback_data' => 'user_get_license_' . $order_id]],
                        [['text' => '🎓 دریافت آموزش سفارش #' . $order_id, 'callback_data' => 'my_order_training_' . $order_id]]
                    ]
                ];
                sendMessage($target_id, $user_msg, $inline_keyboard);
            } else {
                $user_msg = "🎉 سفارش شما با موفقیت ثبت شد!\n\nشماره سفارش: #{$order_id}\nمحصول: {$product_name}\nمنتظر تایید و ارسال لایسنس توسط ادمین باشید.\n\n✅ آموزش را می‌توانید با دکمه زیر دریافت کنید.";
                $inline_keyboard = [
                    'inline_keyboard' => [
                        [['text' => '🎓 دریافت آموزش سفارش #' . $order_id, 'callback_data' => 'my_order_training_' . $order_id]]
                    ]
                ];
                sendMessage($target_id, $user_msg, $inline_keyboard);
            }
            
            sendMessage($chat_id, 'سفارش با موفقیت ثبت شد.' . ($license_sent ? ' لایسنس به صورت خودکار ارسال شد.' : ' اما لایسنس یافت نشد.'));
            @unlink($buy_file);
            
            // ارسال نتیجه به همه ادمین‌ها
            $summary = strip_tags($buy_data['summary']);
            $admin_summary = str_replace('جزئیات سفارش شما', 'جزئیات سفارش', $summary);
            $admin_summary = preg_replace('/\n📸.*$/s', '', $admin_summary);
            $admin_summary = preg_replace('/\n⏳.*$/s', '', $admin_summary);
            
            // ارسال پیام فقط به ادمین اصلی
            $admin_msg = "✅ پرداخت کاربر #$target_id تایید شد.\n\n";
            
            if($license_sent) {
                $admin_msg .= "✅ لایسنس به صورت خودکار ارسال شد: {$license_key}\n";
                $admin_msg .= "✅ وضعیت سفارش به completed تغییر یافت.\n\n";
                $admin_msg .= $admin_summary;
                sendMessage(ADMIN_ID, $admin_msg);
            } else {
                $admin_msg .= "⚠️ لایسنس برای این محصول یافت نشد. لطفاً به صورت دستی تخصیص دهید.\n\n";
                $admin_msg .= $admin_summary;
                $inline_keyboard = [
                    'inline_keyboard' => [
                        [['text' => '🔎 جزئیات سفارش #' . $order_id, 'callback_data' => 'admin_orderdetail_' . $order_id]]
                    ]
                ];
                sendMessage(ADMIN_ID, $admin_msg, $inline_keyboard);
            }
        } else {
            sendMessage($chat_id, 'خطا در ثبت سفارش در سایت.');
        }
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    if(isset($data) && strpos($data, 'buy_reject_') === 0 && $is_admin) {
        $target_id = str_replace('buy_reject_', '', $data);
        // حذف پیام رسید پرداخت برای همه ادمین‌ها
        $stmt_admins = dbQuery("SELECT telegram_id FROM admins");
        while($row = $stmt_admins->fetch()) {
            $admin_id = $row['telegram_id'];
            if(isset($update['callback_query']['message']['message_id'])) {
                deleteMessage($admin_id, $update['callback_query']['message']['message_id']);
            }
        }
        sendMessage($target_id, 'پرداخت شما تایید نشد. لطفاً مجدداً اقدام کنید یا با پشتیبانی تماس بگیرید.');
        sendMessage($chat_id, 'عدم تایید پرداخت ثبت شد.');
        @unlink("buy_step_{$target_id}.tmp");
        // ارسال نتیجه به همه ادمین‌ها
        $buy_file = "buy_step_{$target_id}.tmp";
        $buy_data = @json_decode(@file_get_contents($buy_file), true);
        $summary = $buy_data['summary'] ?? '';
        $msg = "❌ پرداخت کاربر #$target_id رد شد.\n$summary";
        $stmt_admins = dbQuery("SELECT telegram_id FROM admins");
        while($row = $stmt_admins->fetch()) {
            sendMessage($row['telegram_id'], $msg);
        }
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // مدیریت callback_query برای نمایش مدل‌های هر محصول پس از انتخاب محصول
    if(isset($update['callback_query'])) {
        $chat_id = $update['callback_query']['message']['chat']['id'];
        $user_id = $update['callback_query']['from']['id'];
        $data = $update['callback_query']['data'];
        $message_id = $update['callback_query']['message']['message_id'];
        $stmt_admin = dbQuery("SELECT telegram_id FROM admins WHERE telegram_id = ?", [$user_id]);
        $is_admin = ($user_id == ADMIN_ID) || ($stmt_admin->fetch());
        // ... existing code ...
        if(strpos($data, 'admin_licenses_') === 0 && $is_admin) {
            $product_id = str_replace('admin_licenses_', '', $data);
            $error_details = [];
            
            try {
                // دریافت مدل‌های محصول از ووکامرس
                $vars = getProductVariationsFromApi($product_id);
                
                if(!$vars) {
                    $error_details[] = "❌ getProductVariationsFromApi() مقدار null برگرداند";
                    error_log("License Management Error: getProductVariationsFromApi({$product_id}) returned null");
                } elseif(!is_array($vars)) {
                    $error_details[] = "❌ getProductVariationsFromApi() مقدار غیر آرایه برگرداند: " . gettype($vars);
                    error_log("License Management Error: getProductVariationsFromApi({$product_id}) returned non-array: " . gettype($vars));
                } elseif(count($vars) == 0) {
                    $error_details[] = "❌ هیچ متغیری برای محصول ID {$product_id} یافت نشد";
                    
                    // بررسی فایل cache
                    $cache_file = __DIR__ . "/product_vars_cache_{$product_id}.json";
                    $error_details[] = "📁 فایل cache: " . (file_exists($cache_file) ? 'موجود' : 'وجود ندارد');
                    if(file_exists($cache_file)) {
                        $cache_content = file_get_contents($cache_file);
                        $cache_data = json_decode($cache_content, true);
                        $error_details[] = "📊 حجم فایل cache: " . strlen($cache_content) . " بایت";
                        $error_details[] = "📊 JSON معتبر: " . (json_last_error() === JSON_ERROR_NONE ? 'بله' : 'خیر - خطا: ' . json_last_error_msg());
                        if(is_array($cache_data)) {
                            $error_details[] = "📊 تعداد متغیرها در cache: " . count($cache_data);
                        }
                    }
                    
                    // تست API
                    $test_url = WC_API_URL . "/{$product_id}/variations?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
                    $test_response = @file_get_contents($test_url);
                    if($test_response === false) {
                        $error_details[] = "🌐 تست API: ❌ خطا در اتصال";
                        $last_error = error_get_last();
                        if($last_error) {
                            $error_details[] = "   خطا: " . $last_error['message'];
                        }
                    } else {
                        $test_data = json_decode($test_response, true);
                        if(json_last_error() !== JSON_ERROR_NONE) {
                            $error_details[] = "🌐 تست API: ❌ JSON نامعتبر - " . json_last_error_msg();
                        } elseif(!is_array($test_data)) {
                            $error_details[] = "🌐 تست API: ❌ پاسخ غیر آرایه - " . gettype($test_data);
                        } else {
                            $error_details[] = "🌐 تست API: ✅ اتصال برقرار - تعداد متغیرها: " . count($test_data);
                        }
                    }
                    
                    error_log("License Management Error: No variations found for product {$product_id}");
                }
                
                if(!$vars || !is_array($vars) || count($vars) == 0) {
                    $error_msg = "⚠️ خطا در دریافت متغیرهای محصول:\n\n";
                    $error_msg .= "📦 Product ID: {$product_id}\n\n";
                    $error_msg .= implode("\n", $error_details);
                    
                    editMessage($chat_id, $message_id, $error_msg, [
                        'inline_keyboard' => [ [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_panel'] ] ]
                    ]);
                    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                    return;
                }
                
                $inline_keyboard = [];
                $text_vars = "🔢 مدل‌های محصول انتخاب‌شده:\n";
                foreach($vars as $v) {
                    $model_name = [];
                    if(isset($v['attributes']) && is_array($v['attributes'])) {
                        foreach($v['attributes'] as $a) {
                            if(isset($a['option'])) {
                                $model_name[] = $a['option'];
                            }
                        }
                    }
                    $model_name = implode(' | ', $model_name);
                    if(empty($model_name)) {
                        $model_name = "ID: " . ($v['id'] ?? 'نامشخص');
                    }
                    $inline_keyboard[] = [
                        ['text' => "🔢 $model_name", 'callback_data' => 'admin_licensemodel_' . $product_id . '_' . ($v['id'] ?? 0)]
                    ];
                    $text_vars .= "🔢 $model_name\n";
                }
                $inline_keyboard[] = [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_panel'] ];
                editMessage($chat_id, $message_id, $text_vars . "\nبرای مدیریت لایسنس هر مدل، روی دکمه آن کلیک کنید.", ['inline_keyboard'=>$inline_keyboard]);
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
                
            } catch(Exception $e) {
                $error_msg = "⚠️ خطای غیرمنتظره:\n\n";
                $error_msg .= "❌ پیام خطا: " . $e->getMessage() . "\n";
                $error_msg .= "📁 فایل: " . $e->getFile() . "\n";
                $error_msg .= "📍 خط: " . $e->getLine() . "\n";
                
                error_log("License Management Exception: " . $e->getMessage() . " in " . $e->getFile() . ":" . $e->getLine());
                editMessage($chat_id, $message_id, $error_msg, [
                    'inline_keyboard' => [ [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_panel'] ] ]
                ]);
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            } catch(Error $e) {
                $error_msg = "⚠️ خطای فنی:\n\n";
                $error_msg .= "❌ پیام خطا: " . $e->getMessage() . "\n";
                $error_msg .= "📁 فایل: " . $e->getFile() . "\n";
                $error_msg .= "📍 خط: " . $e->getLine() . "\n";
                
                error_log("License Management Fatal Error: " . $e->getMessage() . " in " . $e->getFile() . ":" . $e->getLine());
                editMessage($chat_id, $message_id, $error_msg, [
                    'inline_keyboard' => [ [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_panel'] ] ]
                ]);
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
        }
        // ... existing code ...
    }
    // ... existing code ...
}
// مدیریت ذخیره پیام جدید آموزشی توسط ادمین
if(isset($update['message'])) {
    $chat_id = $update['message']['chat']['id'];
    $user_id = $update['message']['from']['id'];
    $text = $update['message']['text'] ?? '';
    // ثبت پیام جدید آموزشی توسط ادمین (در هر حالت اگر فایل موقت وجود دارد)
    if($user_id == ADMIN_ID && file_exists("admin_addmsg_{$user_id}.tmp")) {
        $product_id = @file_get_contents("admin_addmsg_{$user_id}.tmp");
        if($product_id) {
            @unlink("admin_addmsg_{$user_id}.tmp");
            $msg = $update['message'];
            $type = 'text'; $content = ''; $caption = null;
            if(isset($msg['text'])) { $type = 'text'; $content = $msg['text']; }
            elseif(isset($msg['photo'])) { $type = 'photo'; $content = end($msg['photo'])['file_id']; $caption = $msg['caption'] ?? null; }
            elseif(isset($msg['video'])) { $type = 'video'; $content = $msg['video']['file_id']; $caption = $msg['caption'] ?? null; }
            elseif(isset($msg['voice'])) { $type = 'voice'; $content = $msg['voice']['file_id']; }
            elseif(isset($msg['document'])) { $type = 'file'; $content = $msg['document']['file_id']; $caption = $msg['caption'] ?? null; }
            elseif(isset($msg['forward_from_message_id'])) { // پیام فورواردی
                if(isset($msg['text'])) { $type = 'text'; $content = $msg['text']; }
                elseif(isset($msg['photo'])) { $type = 'photo'; $content = end($msg['photo'])['file_id']; $caption = $msg['caption'] ?? null; }
                elseif(isset($msg['video'])) { $type = 'video'; $content = $msg['video']['file_id']; $caption = $msg['caption'] ?? null; }
                elseif(isset($msg['voice'])) { $type = 'voice'; $content = $msg['voice']['file_id']; }
                elseif(isset($msg['document'])) { $type = 'file'; $content = $msg['document']['file_id']; $caption = $msg['caption'] ?? null; }
            }
            $stmt = dbQuery("SELECT MAX(step_number) as maxstep FROM product_messages WHERE product_id = ?", [$product_id]);
            $row = $stmt->fetch();
            $step = $row && $row['maxstep'] ? $row['maxstep']+1 : 1;
            dbQuery("INSERT INTO product_messages (product_id, step_number, message_type, message_content, caption) VALUES (?, ?, ?, ?, ?)", [$product_id, $step, $type, $content, $caption]);
            sendMessage($chat_id, 'پیام جدید با موفقیت ذخیره شد.');
            adminShowProductMessages($chat_id, $product_id);
            // ارسال خودکار پیام به خریداران قبلی این محصول
            $stmt_notify = dbQuery("SELECT DISTINCT user_id FROM orders WHERE product_id = ?", [$product_id]);
            while($row_notify = $stmt_notify->fetch()) {
                sendMessage($row_notify['user_id'], "آموزش جدید برای محصولی که خریداری کرده‌اید اضافه شد! برای مشاهده آموزش جدید، مجدداً شماره سفارش خود را ارسال کنید.");
                usleep(300000); // جلوگیری از بلاک شدن توسط تلگرام
            }
        }
    }
    // حذف پیام خاص آموزشی (بر اساس شماره)
    if(strpos($text, 'شماره پیام مورد نظر برای حذف') !== false) {
        $product_id = @file_get_contents("admin_delmsg_{$chat_id}.tmp");
        if($product_id) @unlink("admin_delmsg_{$chat_id}.tmp");
        adminDeleteProductMessage($chat_id, $product_id, intval($text));
    }
    // ویرایش پیام خاص آموزشی (بر اساس شماره)
    if(strpos($text, 'شماره پیام مورد نظر برای ویرایش') !== false) {
        $product_id = @file_get_contents("admin_editmsg_{$chat_id}.tmp");
        if($product_id) @unlink("admin_editmsg_{$chat_id}.tmp");
        adminEditProductMessage($chat_id, $product_id, intval($text));
    }
}



// مدیریت انتخاب حالت ویرایش یا حذف پیام خاص
if(isset($data) && strpos($data, 'admin_editmsg_') === 0 && $is_admin) {
    $product_id = str_replace('admin_editmsg_', '', $data);
    adminShowProductMessages($chat_id, $product_id, $message_id, 'edit');
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
if(isset($data) && strpos($data, 'admin_delmsg_') === 0 && $is_admin) {
    $product_id = str_replace('admin_delmsg_', '', $data);
    adminShowProductMessages($chat_id, $product_id, $message_id, 'delete');
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// مدیریت نمایش و حذف/ویرایش هر پیام آموزشی
if(isset($data) && strpos($data, 'admin_msgview_') === 0 && $is_admin) {
    $parts = explode('_', str_replace('admin_msgview_','',$data));
    $product_id = $parts[0];
    $msg_id = $parts[1];
    $stmt = dbQuery("SELECT * FROM product_messages WHERE id = ?", [$msg_id]);
    $msg = $stmt->fetch();
    if(!$msg) { sendMessage($chat_id, 'پیام یافت نشد.'); return; }
    // ارسال محتوای کامل پیام
    if($msg['message_type'] == 'text') {
        sendMessage($chat_id, "پیام {$msg['step_number']}:\n".$msg['message_content']);
    } elseif($msg['message_type'] == 'photo') {
        sendPhoto($chat_id, $msg['message_content'], $msg['caption']);
    } elseif($msg['message_type'] == 'video') {
        sendVideo($chat_id, $msg['message_content'], $msg['caption']);
    } elseif($msg['message_type'] == 'voice') {
        sendVoice($chat_id, $msg['message_content']);
    } elseif($msg['message_type'] == 'file') {
        sendDocument($chat_id, $msg['message_content'], $msg['caption']);
    }
    // دکمه‌های ویرایش/حذف و جابجایی
    $btns = [];
    $btns[] = ['text'=>'✏️ ویرایش همین پیام','callback_data'=>'admin_editmsgdo_'.$product_id.'_'.$msg_id];
    $btns[] = ['text'=>'❌ حذف همین پیام','callback_data'=>'admin_delmsgdo_'.$product_id.'_'.$msg_id];
    // دکمه جابجایی بالا/پایین
    $stmt2 = dbQuery("SELECT id, step_number FROM product_messages WHERE product_id = ? ORDER BY step_number ASC", [$product_id]);
    $all = $stmt2->fetchAll();
    $current_index = null;
    foreach($all as $i => $row) if($row['id'] == $msg_id) $current_index = $i;
    if($current_index !== null) {
        if($current_index > 0)
            $btns[] = ['text'=>'⬆️ بالا','callback_data'=>'admin_msgmoveup_'.$product_id.'_'.$msg_id];
        if($current_index < count($all)-1)
            $btns[] = ['text'=>'⬇️ پایین','callback_data'=>'admin_msgmovedown_'.$product_id.'_'.$msg_id];
    }
    $btns[] = ['text'=>'🔙 بازگشت','callback_data'=>'admin_trainings_'.$product_id];
    sendMessage($chat_id, 'انتخاب عملیات:', ['inline_keyboard'=>[$btns]]);
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// جابجایی پیام آموزشی به بالا
if(isset($data) && strpos($data, 'admin_msgmoveup_') === 0 && $is_admin) {
    $parts = explode('_', str_replace('admin_msgmoveup_','',$data));
    $product_id = $parts[0];
    $msg_id = $parts[1];
    $stmt = dbQuery("SELECT id, step_number FROM product_messages WHERE product_id = ? ORDER BY step_number ASC", [$product_id]);
    $all = $stmt->fetchAll();
    foreach($all as $i => $row) {
        if($row['id'] == $msg_id && $i > 0) {
            // جابجایی با پیام قبلی
            dbQuery("UPDATE product_messages SET step_number = ? WHERE id = ?", [$all[$i-1]['step_number'], $row['id']]);
            dbQuery("UPDATE product_messages SET step_number = ? WHERE id = ?", [$row['step_number'], $all[$i-1]['id']]);
            break;
        }
    }
    adminShowProductMessages($chat_id, $product_id);
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// جابجایی پیام آموزشی به پایین
if(isset($data) && strpos($data, 'admin_msgmovedown_') === 0 && $is_admin) {
    $parts = explode('_', str_replace('admin_msgmovedown_','',$data));
    $product_id = $parts[0];
    $msg_id = $parts[1];
    $stmt = dbQuery("SELECT id, step_number FROM product_messages WHERE product_id = ? ORDER BY step_number ASC", [$product_id]);
    $all = $stmt->fetchAll();
    foreach($all as $i => $row) {
        if($row['id'] == $msg_id && $i < count($all)-1) {
            // جابجایی با پیام بعدی
            dbQuery("UPDATE product_messages SET step_number = ? WHERE id = ?", [$all[$i+1]['step_number'], $row['id']]);
            dbQuery("UPDATE product_messages SET step_number = ? WHERE id = ?", [$row['step_number'], $all[$i+1]['id']]);
            break;
        }
    }
    adminShowProductMessages($chat_id, $product_id);
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// انجام حذف پیام خاص
if(isset($data) && strpos($data, 'admin_delmsgdo_') === 0 && $is_admin) {
    $parts = explode('_', str_replace('admin_delmsgdo_','',$data));
    $product_id = $parts[0];
    $msg_id = $parts[1];
    dbQuery("DELETE FROM product_messages WHERE id = ?", [$msg_id]);
    // بازشماری step_number
    $stmt2 = dbQuery("SELECT id FROM product_messages WHERE product_id = ? ORDER BY step_number ASC", [$product_id]);
    $all = $stmt2->fetchAll();
    foreach($all as $i => $row) dbQuery("UPDATE product_messages SET step_number = ? WHERE id = ?", [$i+1, $row['id']]);
    sendMessage($chat_id, 'پیام مورد نظر حذف شد.');
    adminShowProductMessages($chat_id, $product_id);
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// انجام ویرایش پیام خاص
if(isset($data) && strpos($data, 'admin_editmsgdo_') === 0 && $is_admin) {
    $parts = explode('_', str_replace('admin_editmsgdo_','',$data));
    $product_id = $parts[0];
    $msg_id = $parts[1];
    file_put_contents("admin_editmsgdo_{$chat_id}.tmp", json_encode(['product_id'=>$product_id,'msg_id'=>$msg_id]));
    sendMessage($chat_id, 'پیام جدید (متن، عکس، ویدیو، ویس یا فوروارد) را برای جایگزینی ارسال کنید:', ["force_reply" => true]);
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// مدیریت ForceReply ویرایش پیام خاص آموزشی
if(isset($update['message']) && file_exists("admin_editmsgdo_{$chat_id}.tmp")) {
    $info = json_decode(@file_get_contents("admin_editmsgdo_{$chat_id}.tmp"), true);
    @unlink("admin_editmsgdo_{$chat_id}.tmp");
    $product_id = $info['product_id'];
    $msg_id = $info['msg_id'];
    $msg = $update['message'];
    $type = 'text'; $content = ''; $caption = null;
    if(isset($msg['text'])) { $type = 'text'; $content = $msg['text']; }
    elseif(isset($msg['photo'])) { $type = 'photo'; $content = end($msg['photo'])['file_id']; $caption = $msg['caption'] ?? null; }
    elseif(isset($msg['video'])) { $type = 'video'; $content = $msg['video']['file_id']; $caption = $msg['caption'] ?? null; }
    elseif(isset($msg['voice'])) { $type = 'voice'; $content = $msg['voice']['file_id']; }
    elseif(isset($msg['document'])) { $type = 'file'; $content = $msg['document']['file_id']; $caption = $msg['caption'] ?? null; }
    elseif(isset($msg['forward_from_message_id'])) {
        if(isset($msg['text'])) { $type = 'text'; $content = $msg['text']; }
        elseif(isset($msg['photo'])) { $type = 'photo'; $content = end($msg['photo'])['file_id']; $caption = $msg['caption'] ?? null; }
        elseif(isset($msg['video'])) { $type = 'video'; $content = $msg['video']['file_id']; $caption = $msg['caption'] ?? null; }
        elseif(isset($msg['voice'])) { $type = 'voice'; $content = $msg['voice']['file_id']; }
        elseif(isset($msg['document'])) { $type = 'file'; $content = $msg['document']['file_id']; $caption = $msg['caption'] ?? null; }
    }
    dbQuery("UPDATE product_messages SET message_type=?, message_content=?, caption=? WHERE id=?", [$type, $content, $caption, $msg_id]);
    sendMessage($chat_id, 'پیام با موفقیت ویرایش شد.');
    adminShowProductMessages($chat_id, $product_id);
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}

// افزودن ادمین اصلی به جدول admins (در صورت نبود)
dbQuery("INSERT IGNORE INTO admins (telegram_id) VALUES (?)", [ADMIN_ID]);

// شمارنده خطاهای کاربر
function increaseUserError($user_id) {
    $file = "errorcount_{$user_id}.tmp";
    $count = (int)@file_get_contents($file);
    $count++;
    file_put_contents($file, $count);
    return $count;
}
function resetUserError($user_id) {
    $file = "errorcount_{$user_id}.tmp";
    @unlink($file);
}
// ساخت کد تخفیف اختصاصی برای کاربر توسط ادمین
if(strpos($data, 'admin_usercoupon_') === 0 && $is_admin) {
    $user_tg_id = str_replace('admin_usercoupon_', '', $data);
    // اعتبارسنجی user_tg_id
    $user_tg_id = preg_replace('/[^0-9]/', '', $user_tg_id);
    if(empty($user_tg_id) || strlen($user_tg_id) > 20) {
        sendMessage($chat_id, 'آیدی کاربر معتبر نیست.');
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    sendMessage($chat_id, 'درصد تخفیف، تعداد روز اعتبار و تعداد دفعات استفاده را با کاما وارد کنید (مثال: 20,3,1):', ["force_reply" => true]);
    file_put_contents("admin_usercoupon_{$chat_id}.tmp", $user_tg_id);
}
// مدیریت ساخت کد تخفیف اختصاصی توسط ادمین (ForceReply)
if(isset($update['message']) && isset($update['message']['reply_to_message']['text'])) {
    $reply_text = $update['message']['reply_to_message']['text'];
    $chat_id = $update['message']['chat']['id'];
    $user_id = $update['message']['from']['id'];
    $text = $update['message']['text'];
    // بن ساعتی کاربر
    if(file_exists("admin_userban_{$chat_id}.tmp")) {
        $target_id = @file_get_contents("admin_userban_{$chat_id}.tmp");
        @unlink("admin_userban_{$chat_id}.tmp");
        $hours = intval($text);
        if($hours <= 0) {
            sendMessage($chat_id, 'عدد وارد شده معتبر نیست.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $until = date('Y-m-d H:i:s', time() + $hours*3600);
        dbQuery("INSERT INTO blacklist (telegram_id, until) VALUES (?, ?) ON DUPLICATE KEY UPDATE until = ?", [$target_id, $until, $until]);
        sendMessage($chat_id, "کاربر به مدت {$hours} ساعت بن شد.");
        sendMessage($target_id, "⛔️ دسترسی شما به مدت {$hours} ساعت توسط مدیر مسدود شد. لطفاً بعداً تلاش کنید.");
        logAdminAction($user_id, 'ban_user', $target_id, "hours:{$hours}");
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    // ساخت کد تخفیف اختصاصی
    if(file_exists("admin_usercoupon_{$chat_id}.tmp")) {
        $user_tg_id = @file_get_contents("admin_usercoupon_{$chat_id}.tmp");
        @unlink("admin_usercoupon_{$chat_id}.tmp");
        // اعتبارسنجی user_tg_id
        $user_tg_id = preg_replace('/[^0-9]/', '', $user_tg_id);
        if(empty($user_tg_id) || strlen($user_tg_id) > 20) {
            sendMessage($chat_id, 'خطا در دریافت اطلاعات کاربر.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $parts = explode(',', $text);
        if(count($parts) != 3) {
            sendMessage($chat_id, 'فرمت ورودی صحیح نیست. مثال: 20,3,1');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // اعتبارسنجی ورودی‌ها
        $percent = intval(trim($parts[0]));
        $days = intval(trim($parts[1]));
        $usage = intval(trim($parts[2]));
        // محدودیت‌های منطقی
        if($percent < 1 || $percent > 100) {
            sendMessage($chat_id, 'درصد تخفیف باید بین 1 تا 100 باشد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        if($days < 1 || $days > 365) {
            sendMessage($chat_id, 'تعداد روز باید بین 1 تا 365 باشد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        if($usage < 1 || $usage > 1000) {
            sendMessage($chat_id, 'تعداد دفعات استفاده باید بین 1 تا 1000 باشد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // ادامه کد ساخت کوپن...
        $expire = date('Y-m-d', strtotime("+{$days} days"));
        $code = 'GC' . strtoupper(substr(md5($user_tg_id . time()), 0, 8));
        $url = "https://goldencheat.ir/wp-json/wc/v3/coupons?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
        $payload = json_encode([
            'code' => $code,
            'discount_type' => 'percent',
            'amount' => $percent,
            'usage_limit' => $usage,
            'date_expires' => $expire,
            'individual_use' => true,
            'customer_ids' => []
        ]);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json', 'Content-Length: ' . strlen($payload)]);
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if($http_code == 201) {
            $coupon = json_decode($response, true);
            $coupon_id = $coupon['id'];
            dbQuery("INSERT INTO user_coupons (user_telegram_id, coupon_id, coupon_code) VALUES (?, ?, ?)", [$user_tg_id, $coupon_id, $code]);
            sendMessage($chat_id, "کد تخفیف {$percent}% با موفقیت برای کاربر ساخته شد:\nکد: {$code}\nاعتبار: {$days} روز\nاستفاده: {$usage} بار");
            sendMessage($user_tg_id, "🎁 کد تخفیف اختصاصی شما:\nکد: <code>{$code}</code>\nدرصد: {$percent}%\nاعتبار: {$days} روز\nتعداد استفاده: {$usage} بار");
        } else {
            sendMessage($chat_id, 'خطا در ساخت کد تخفیف. لطفاً دوباره تلاش کنید.');
        }
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
}
// مدیریت رفع بن کاربر
if(strpos($data, 'admin_unban_') === 0 && $is_admin) {
    $user_tg_id = str_replace('admin_unban_', '', $data);
    dbQuery("DELETE FROM blacklist WHERE telegram_id = ?", [$user_tg_id]);
    sendMessage($chat_id, 'بن کاربر با موفقیت رفع شد.');
    sendMessage($user_tg_id, '✅ بن شما توسط مدیر رفع شد و می‌توانید از ربات استفاده کنید.');
    logAdminAction($user_id, 'unban_user', $user_tg_id, 'رفع بن توسط ادمین');
    // بازگشت به زیرمنوی کاربر
    $stmt = dbQuery("SELECT mobile, created_at FROM users WHERE telegram_id = ?", [$user_tg_id]);
    $user = $stmt->fetch();
    $stmt2 = dbQuery("SELECT COUNT(*) as cnt FROM orders WHERE user_id = ?", [$user_tg_id]);
    $order_count = $stmt2->fetch()['cnt'] ?? 0;
    $mobile = $user['mobile'] ? $user['mobile'] : '---';
    $created = $user['created_at'];
    $text = "👤 اطلاعات کاربر:\nشماره: {$mobile}\nتاریخ عضویت: {$created}\nتعداد سفارش: {$order_count}";
    $keyboard = [
        'inline_keyboard' => [
            [ ['text'=>'📦 سفارشات کاربر','callback_data'=>'admin_userorders_'.$user_tg_id] ],
            [ ['text'=>'✉️ ارسال پیام شخصی','callback_data'=>'admin_usermsg_'.$user_tg_id] ],
            [ ['text'=>'🎁 ساخت کد تخفیف','callback_data'=>'admin_usercoupon_'.$user_tg_id] ],
            [ ['text'=>'⛔️ بن ساعتی','callback_data'=>'admin_userban_'.$user_tg_id] ],
        ]
    ];
    editMessage($chat_id, $message_id, $text, $keyboard);
}
// جستجو با شماره موبایل توسط ادمین
if(strpos($data, 'admin_searchuser') === 0 && $is_admin) {
    sendMessage($chat_id, 'شماره موبایل کاربر را وارد کنید:', ["force_reply" => true]);
    file_put_contents("admin_searchuser_{$chat_id}.tmp", 1);
}
// مدیریت جستجو با شماره موبایل توسط ادمین (ForceReply)
if(isset($update['message']) && isset($update['message']['reply_to_message']['text'])) {
    $reply_text = $update['message']['reply_to_message']['text'];
    $chat_id = $update['message']['chat']['id'];
    $user_id = $update['message']['from']['id'];
    $text = $update['message']['text'];
    // جستجو با شماره موبایل
    if(file_exists("admin_searchuser_{$chat_id}.tmp")) {
        @unlink("admin_searchuser_{$chat_id}.tmp");
        $mobile = normalizeMobile($text);
        $stmt = dbQuery("SELECT telegram_id FROM users WHERE mobile = ?", [$mobile]);
        $row = $stmt->fetch();
        if($row && $row['telegram_id']) {
            // نمایش زیرمنوی مدیریتی همان کاربر
            $user_tg_id = $row['telegram_id'];
            $stmt = dbQuery("SELECT mobile, created_at FROM users WHERE telegram_id = ?", [$user_tg_id]);
            $user = $stmt->fetch();
            $stmt2 = dbQuery("SELECT COUNT(*) as cnt FROM orders WHERE user_id = ?", [$user_tg_id]);
            $order_count = $stmt2->fetch()['cnt'] ?? 0;
            $mobile = $user['mobile'] ? $user['mobile'] : '---';
            $created = $user['created_at'];
            $text = "👤 اطلاعات کاربر:\nشماره: {$mobile}\nتاریخ عضویت: {$created}\nتعداد سفارش: {$order_count}";
            $keyboard = [
                'inline_keyboard' => [
                    [ ['text'=>'📦 سفارشات کاربر','callback_data'=>'admin_userorders_'.$user_tg_id] ],
                    [ ['text'=>'✉️ ارسال پیام شخصی','callback_data'=>'admin_usermsg_'.$user_tg_id] ],
                    [ ['text'=>'🎁 ساخت کد تخفیف','callback_data'=>'admin_usercoupon_'.$user_tg_id] ],
                    [ ['text'=>'⛔️ بن ساعتی','callback_data'=>'admin_userban_'.$user_tg_id] ],
                    [ ['text'=>'🔙 بازگشت','callback_data'=>'admin_recentusers_0'] ]
                ]
            ];
            sendMessage($chat_id, $text, $keyboard);
        } else {
            sendMessage($chat_id, 'کاربری با این شماره یافت نشد.');
        }
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
}
// تابع ثبت لاگ مدیریتی
function logAdminAction($admin_id, $action, $target_id, $desc = '') {
    $line = date('Y-m-d H:i:s') . " | admin:{$admin_id} | action:{$action} | target:{$target_id} | {$desc}\n";
    file_put_contents('admin_actions.log', $line, FILE_APPEND);
}
// هندل دکمه پیام همگانی
if(isset($data) && $data == 'admin_broadcast' && $is_admin) {
    sendMessage($chat_id, "متن پیام همگانی را وارد کنید:", ["force_reply" => true]);
    file_put_contents("broadcast_{$user_id}.tmp", 1);
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// هندل ارسال پیام همگانی توسط مدیر
if($is_admin && isset($update['message']['text']) && file_exists("broadcast_{$user_id}.tmp")) {
    @unlink("broadcast_{$user_id}.tmp");
    $msg = $update['message']['text'];
    $stmt = dbQuery("SELECT telegram_id FROM users");
    while($row = $stmt->fetch()) {
        sendMessage($row['telegram_id'], $msg);
        usleep(300000);
    }
    sendMessage($chat_id, "پیام همگانی با موفقیت برای همه کاربران ارسال شد.");
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// هندل مدیریت کاربر از دکمه شیشه‌ای
if(isset($update['callback_query']) && isset($update['callback_query']['data'])) {
    $data = $update['callback_query']['data'];
    $chat_id = $update['callback_query']['message']['chat']['id'];
    $user_id = $update['callback_query']['from']['id'];
    $is_admin = ($user_id == ADMIN_ID) || dbQuery("SELECT telegram_id FROM admins WHERE telegram_id = ?", [$user_id])->fetch();
    // مدیریت کاربر
    if(strpos($data, 'admin_manageuser_') === 0 && $is_admin) {
        $target_id = str_replace('admin_manageuser_', '', $data);
        $stmt = dbQuery("SELECT mobile, created_at FROM users WHERE telegram_id = ?", [$target_id]);
        $user = $stmt->fetch();
        if(!$user) {
            sendMessage($chat_id, 'کاربر یافت نشد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        $mobile = $user['mobile'] ? $user['mobile'] : '---';
        $created = $user['created_at'];
        $text = "👤 اطلاعات کاربر:\nشماره: {$mobile}\nتاریخ عضویت: {$created}";
        // سفارشات کاربر
        $url = "https://goldencheat.ir/wp-json/wc/v3/orders?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET . "&status=processing,completed,refunded";
        $response = @file_get_contents($url);
        $orders = json_decode($response, true);
        $user_orders = [];
        if($orders && is_array($orders)) {
            foreach($orders as $order) {
                $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
                if($order_mobile == $mobile) {
                    $user_orders[] = $order;
                }
            }
        }
        $inline_keyboard = [];
        if($user_orders) {
            $text .= "\n\n📦 سفارشات کاربر:";
            foreach($user_orders as $order) {
                $oid = $order['id'];
                $pname = $order['line_items'][0]['name'] ?? '-';
                $status_map = [
                    'processing' => 'در حال انجام',
                    'completed' => 'تکمیل‌شده',
                    'refunded' => 'مسترد شده',
                    'cancelled' => 'لغو شده',
                    'pending' => 'در انتظار پرداخت'
                ];
                $status_fa = $status_map[$order['status']] ?? $order['status'];
                $btn_text = "🧾 سفارش #{$oid} | {$pname} | {$status_fa}";
                $inline_keyboard[] = [ ['text' => $btn_text, 'callback_data' => 'admin_manageorder_' . $oid] ];
                $text .= "\n" . $btn_text;
            }
        } else {
            $text .= "\nسفارشی برای این کاربر یافت نشد.";
        }
        $reply_markup = [
            'inline_keyboard' => $inline_keyboard
        ];
        sendMessage($chat_id, $text . "\nبرای مدیریت هر سفارش روی دکمه کلیک کنید.", $reply_markup);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
}
// هندل دکمه ارسال لایسنس به کاربر
if(isset($data) && strpos($data, 'admin_sendlicense_') === 0 && $is_admin) {
    $order_id = str_replace('admin_sendlicense_', '', $data);
    sendMessage($chat_id, 'فقط لایسنس را به صورت متنی ارسال کنید (بدون هیچ توضیحی):', ["force_reply" => true]);
    file_put_contents("admin_sendlicense_{$chat_id}.tmp", $order_id);
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// ثبت لایسنس و ارسال به کاربر با وایب خفن
if($is_admin && file_exists("admin_sendlicense_{$chat_id}.tmp") && isset($update['message']['text'])) {
    $order_id = @file_get_contents("admin_sendlicense_{$chat_id}.tmp");
    @unlink("admin_sendlicense_{$chat_id}.tmp");
    $license = trim($update['message']['text']);
    // افزودن یادداشت به ووکامرس
    $url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}/notes?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
    $payload = json_encode([
        'note' => $license,
        'customer_note' => true
    ]);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Content-Length' => strlen($payload)
    ]);
    $result = curl_exec($ch);
    curl_close($ch);
    // ارسال پیام خفن به کاربر
    $order = getOrderFromApi($order_id);
    $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
    if($order_mobile && strlen($order_mobile) === 11 && strpos($order_mobile, '09') === 0) {
        $stmt = dbQuery("SELECT telegram_id FROM users WHERE mobile = ?", [$order_mobile]);
        if($row = $stmt->fetch()) {
            $msg = "🚨 خبر داغ از گلدن چیت 🍾\n";
            $msg .= "🎩 ساقی انواع چیت‌های ارجینال رسید خدمتتون 😌💼\n";
            $msg .= "💉 دوز مخصوص امروز: لایسنس چیت خفن شما!\n\n";
            $msg .= "🎮 🔑 <code>{$license}</code> 🔑 🎮\n\n";
            $msg .= "🔥 با احتیاط مصرف شَوَد؛ ممکنه اعتیاد پیدا بکنی 😈😂\n";
            $msg .= "اگه مشکلی بود، ساقی همیشه آنلاینه 💬📲\n";
            
            // اضافه کردن دکمه دریافت آموزش
            $inline_keyboard = [
                'inline_keyboard' => [
                    [['text' => '📚 دریافت آموزش', 'callback_data' => 'get_tutorial']]
                ]
            ];
            
            sendMessage($row['telegram_id'], $msg, $inline_keyboard);
        }
    }
    
    // تغییر وضعیت سفارش به تکمیل شده
    $url_status = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
    $payload_status = json_encode(['status' => 'completed']);
    $ch_status = curl_init($url_status);
    curl_setopt($ch_status, CURLOPT_CUSTOMREQUEST, "PUT");
    curl_setopt($ch_status, CURLOPT_POSTFIELDS, $payload_status);
    curl_setopt($ch_status, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch_status, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Content-Length' => strlen($payload_status)
    ]);
    $result_status = curl_exec($ch_status);
    curl_close($ch_status);
    
    // ارسال پیام به ادمین‌ها با جزئیات سفارش
    $admin_message = "✅ شماره سفارش: #{$order_id} با موفقیت لایسنس ارسال شد و وضعیت سفارش به تکمیل شده تغییر کرد.\n";
    $admin_message .= "🔰 جزئییات سفارش:\n";
    $admin_message .= "محصول(ها): " . implode(', ', array_map(function($item) {
        return $item['name'];
    }, $order['line_items'])) . "\n";
    $admin_message .= "نام خریدار: " . $order['billing']['first_name'] . ' ' . $order['billing']['last_name'] . "\n";
    $admin_message .= "وضعیت کاربر: عضو ربات است\n";
    $admin_message .= "وضعیت: تکمیل شده\n";
    $admin_message .= "لایسنس ارسالی: {$license}";
    
    // ارسال پیام فقط به ادمین اصلی
    sendMessage(ADMIN_ID, $admin_message);
    
    sendMessage($chat_id, '✅ لایسنس با موفقیت به عنوان یادداشت ثبت و برای کاربر ارسال شد و وضعیت سفارش به تکمیل شده تغییر کرد.');
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// ثبت لایسنس و ارسال به کاربر با وایب خفن (ForceReply)
if($is_admin && file_exists("admin_sendlicense_{$chat_id}.tmp")) {
    $order_id = @file_get_contents("admin_sendlicense_{$chat_id}.tmp");
    @unlink("admin_sendlicense_{$chat_id}.tmp");
    $license = trim($text);
    // افزودن یادداشت به ووکامرس
    $url = "https://goldencheat.ir/wp-json/wc/v3/orders/{$order_id}/notes?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET;
    $payload = json_encode([
        'note' => $license,
        'customer_note' => true
    ]);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Content-Length' => strlen($payload)
    ]);
    $result = curl_exec($ch);
    curl_close($ch);
    // ارسال پیام خفن به کاربر
    $order = getOrderFromApi($order_id);
    $order_mobile = normalizeMobile($order['billing']['phone'] ?? '');
    if($order_mobile && strlen($order_mobile) === 11 && strpos($order_mobile, '09') === 0) {
        $stmt = dbQuery("SELECT telegram_id FROM users WHERE mobile = ?", [$order_mobile]);
        if($row = $stmt->fetch()) {
            $msg = "🚨 خبر داغ از گلدن چیت 🍾\n";
            $msg .= "🎩 ساقی انواع چیت‌های ارجینال رسید خدمتتون 😌💼\n";
            $msg .= "💉 دوز مخصوص امروز: لایسنس چیت خفن شما!\n\n";
            $msg .= "🎮 🔑 <code>{$license}</code> 🔑 🎮\n\n";
            $msg .= "🔥 با احتیاط مصرف شَوَد؛ ممکنه اعتیاد پیدا بکنی 😈😂\n";
            $msg .= "اگه مشکلی بود، ساقی همیشه آنلاینه 💬📲\n";
            
            // اضافه کردن دکمه دریافت آموزش
            $inline_keyboard = [
                'inline_keyboard' => [
                    [['text' => '📚 دریافت آموزش', 'callback_data' => 'get_tutorial']]
                ]
            ];
            
            sendMessage($row['telegram_id'], $msg, $inline_keyboard);
        }
    }
    sendMessage($chat_id, '✅ لایسنس با موفقیت به عنوان یادداشت ثبت و برای کاربر ارسال شد.');
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// هندل دکمه ارسال لایسنس به کاربر (reply_keyboard)
if($is_admin && $text == '🚀 ارسال لایسنس به کاربر' && file_exists("admin_selected_order_{$chat_id}.tmp")) {
    $order_id = @file_get_contents("admin_selected_order_{$chat_id}.tmp");
    sendMessage($chat_id, 'فقط لایسنس را به صورت متنی ارسال کنید (بدون هیچ توضیحی):', ["force_reply" => true]);
    file_put_contents("admin_sendlicense_{$chat_id}.tmp", $order_id);
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}
// هندل دریافت عکس رسید پرداخت توسط کاربر
if(isset($update['message']['photo']) && file_exists("buy_step_{$user_id}.tmp")) {
    $loading_message_id = sendMessage($chat_id, '⏳ در حال بارگذاری، لطفا صبور باشید...');
    $buy_data = @json_decode(@file_get_contents("buy_step_{$user_id}.tmp"), true);
    if(isset($buy_data['step']) && $buy_data['step'] == 'upload_receipt') {
        $photo = end($update['message']['photo']);
        $file_id = $photo['file_id'];
        $summary = $buy_data['summary'];
        // ساخت پیام مناسب برای ادمین (بدون متن‌های مشتری‌نما)
        $admin_summary = str_replace('جزئیات سفارش شما', 'جزئیات سفارش', $summary);
        // حذف دستورالعمل‌های مشتری (خطوط آخر)
        $admin_summary = preg_replace('/\n📸.*$/s', '', $admin_summary);
        $admin_summary = preg_replace('/\n⏳.*$/s', '', $admin_summary);
        // حذف تگ‌های HTML از پیام
        $admin_summary = strip_tags($admin_summary);
        // ارسال برای ادمین‌ها
        $stmt_admins = dbQuery("SELECT telegram_id FROM admins");
        while($row = $stmt_admins->fetch()) {
            $admin_id = $row['telegram_id'];
            $caption = "درخواست خرید جدید توسط کاربر #$user_id\n$admin_summary\n\nآیا پرداخت تایید شود؟";
            $inline = [
                'inline_keyboard' => [
                    [
                        ['text'=>'✅ تایید پرداخت','callback_data'=>'buy_confirm_'.$user_id],
                        ['text'=>'❌ عدم تایید','callback_data'=>'buy_reject_'.$user_id]
                    ]
                ]
            ];
            sendPhoto($admin_id, $file_id, $caption, $inline);
        }
        sendMessage($chat_id, 'رسید پرداخت شما با موفقیت ارسال شد و در حال بررسی توسط ادمین است.');
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
}
// ... existing code ...

// مدیریت لایسنس محصولات - باید قبل از کد خرید محصول بررسی شود
if($text == '🔑 مدیریت لایسنس محصولات' && $is_admin) {
    // لاگ برای دیباگ
    error_log("License Management: Starting - chat_id: {$chat_id}, user_id: {$user_id}");
    
    $error_details = [];
    
    try {
        // دریافت محصولات از API
        error_log("License Management: Calling getProductsFromApi()");
        $all_products = getProductsFromApi();
        error_log("License Management: getProductsFromApi() returned: " . gettype($all_products) . (is_array($all_products) ? " (count: " . count($all_products) . ")" : ""));
        
        // بررسی اینکه آیا محصولات دریافت شدند
        if(!is_array($all_products)) {
            $error_details[] = "❌ getProductsFromApi() مقدار غیر آرایه برگرداند";
            error_log("License Management Error: getProductsFromApi() returned non-array: " . gettype($all_products));
        } elseif(count($all_products) == 0) {
            $error_details[] = "❌ هیچ محصولی از API دریافت نشد";
            $error_details[] = "📁 بررسی فایل cache: " . (file_exists(__DIR__ . '/products_cache.json') ? 'موجود' : 'وجود ندارد');
            if(file_exists(__DIR__ . '/products_cache.json')) {
                $cache_content = file_get_contents(__DIR__ . '/products_cache.json');
                $cache_data = json_decode($cache_content, true);
                $error_details[] = "📊 حجم فایل cache: " . strlen($cache_content) . " بایت";
                $error_details[] = "📊 JSON معتبر: " . (json_last_error() === JSON_ERROR_NONE ? 'بله' : 'خیر - خطا: ' . json_last_error_msg());
                if(is_array($cache_data)) {
                    $error_details[] = "📊 تعداد محصولات در cache: " . count($cache_data);
                }
            }
            error_log("License Management Error: No products returned from getProductsFromApi()");
        }
        
        $products = [];
        $variation_errors = [];
        
        // بررسی اینکه آیا $all_products یک آرایه معتبر است
        if(!is_array($all_products)) {
            $error_msg = "⚠️ خطا در دریافت محصولات:\n\n";
            $error_msg .= "❌ getProductsFromApi() مقدار غیر آرایه برگرداند: " . gettype($all_products);
            if($all_products === null) {
                $error_msg .= " (null)";
            }
            $error_msg .= "\n\n🔍 بررسی‌های بیشتر:";
            $error_msg .= "\n• URL API: " . WC_API_URL;
            $error_msg .= "\n• Consumer Key: " . (defined('WC_CONSUMER_KEY') && WC_CONSUMER_KEY ? 'تعریف شده' : 'تعریف نشده');
            $error_msg .= "\n• Consumer Secret: " . (defined('WC_CONSUMER_SECRET') && WC_CONSUMER_SECRET ? 'تعریف شده' : 'تعریف نشده');
            
            sendMessage($chat_id, $error_msg);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        
        foreach($all_products as $p) {
            if((isset($p["status"]) && $p["status"] !== "publish") || (isset($p["stock_status"]) && $p["stock_status"] !== "instock")) continue;
            if(isset($p["type"]) && !in_array($p["type"], ["simple", "variable"])) continue;
            
            if(isset($p["type"]) && $p["type"] == "variable") {
                try {
                    $vars = getProductVariationsFromApi($p["id"]);
                    if(!is_array($vars) || count($vars) == 0) {
                        $variation_errors[] = "محصول ID {$p['id']} ({$p['name']}): متغیرها دریافت نشد";
                        continue;
                    }
                } catch(Exception $e) {
                    $variation_errors[] = "محصول ID {$p['id']} ({$p['name']}): خطا در دریافت متغیرها - " . $e->getMessage();
                    error_log("License Management Error: Failed to get variations for product {$p['id']}: " . $e->getMessage());
                    continue;
                }
            }
            $products[] = $p;
        }
        
        // اگر محصولی پیدا نشد، خطا نمایش بده
        if(count($products) == 0) {
            $error_msg = "⚠️ خطا در دریافت محصولات:\n\n";
            $error_msg .= implode("\n", $error_details);
            
            if(count($variation_errors) > 0) {
                $error_msg .= "\n\n📋 خطاهای متغیرها:\n" . implode("\n", array_slice($variation_errors, 0, 5));
                if(count($variation_errors) > 5) {
                    $error_msg .= "\n... و " . (count($variation_errors) - 5) . " خطای دیگر";
                }
            }
            
            $error_msg .= "\n\n🔍 بررسی‌های بیشتر:";
            $error_msg .= "\n• URL API: " . WC_API_URL;
            $error_msg .= "\n• Consumer Key: " . (defined('WC_CONSUMER_KEY') && WC_CONSUMER_KEY ? 'تعریف شده' : 'تعریف نشده');
            $error_msg .= "\n• Consumer Secret: " . (defined('WC_CONSUMER_SECRET') && WC_CONSUMER_SECRET ? 'تعریف شده' : 'تعریف نشده');
            
            // تست اتصال به API
            $test_url = WC_API_URL . "?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET . "&per_page=1";
            $test_response = @file_get_contents($test_url);
            if($test_response === false) {
                $error_msg .= "\n• تست API: ❌ خطا در اتصال به API";
                $error_msg .= "\n• خطای PHP: " . (error_get_last() ? error_get_last()['message'] : 'نامشخص');
            } else {
                $test_data = json_decode($test_response, true);
                if(json_last_error() !== JSON_ERROR_NONE) {
                    $error_msg .= "\n• تست API: ❌ پاسخ JSON نامعتبر - " . json_last_error_msg();
                } elseif(!is_array($test_data)) {
                    $error_msg .= "\n• تست API: ❌ پاسخ غیر آرایه - " . gettype($test_data);
                } else {
                    $error_msg .= "\n• تست API: ✅ اتصال برقرار است";
                    $error_msg .= "\n• تعداد محصولات در تست: " . count($test_data);
                }
            }
            
            sendMessage($chat_id, $error_msg);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        
        $inline_keyboard = [];
        $text_products = '📦 محصولات برای مدیریت لایسنس:\n';
        foreach($products as $p) {
            $inline_keyboard[] = [
                ['text' => "🔑 {$p['name']}", 'callback_data' => 'admin_licenses_' . $p['id']]
            ];
            $text_products .= "🔑 {$p['name']}\n";
        }
        $inline_keyboard[] = [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_panel'] ];
        sendMessage($chat_id, $text_products . "\nبرای مدیریت لایسنس هر محصول، روی دکمه آن کلیک کنید.", ['inline_keyboard'=>$inline_keyboard]);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
        
    } catch(Exception $e) {
        $error_msg = "⚠️ خطای غیرمنتظره:\n\n";
        $error_msg .= "❌ پیام خطا: " . $e->getMessage() . "\n";
        $error_msg .= "📁 فایل: " . $e->getFile() . "\n";
        $error_msg .= "📍 خط: " . $e->getLine() . "\n";
        $error_msg .= "\n🔍 Stack Trace:\n" . $e->getTraceAsString();
        
        error_log("License Management Exception: " . $e->getMessage() . " in " . $e->getFile() . ":" . $e->getLine());
        sendMessage($chat_id, $error_msg);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    } catch(Error $e) {
        $error_msg = "⚠️ خطای فنی:\n\n";
        $error_msg .= "❌ پیام خطا: " . $e->getMessage() . "\n";
        $error_msg .= "📁 فایل: " . $e->getFile() . "\n";
        $error_msg .= "📍 خط: " . $e->getLine() . "\n";
        
        error_log("License Management Fatal Error: " . $e->getMessage() . " in " . $e->getFile() . ":" . $e->getLine());
        sendMessage($chat_id, $error_msg);
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
}

// مدیریت ForceReply افزودن لایسنس جدید - باید قبل از کد خرید محصول بررسی شود
if($is_admin && isset($update['message']['text']) && file_exists("admin_licenseadd_{$chat_id}.tmp")) {
    $info = json_decode(@file_get_contents("admin_licenseadd_{$chat_id}.tmp"), true);
    @unlink("admin_licenseadd_{$chat_id}.tmp");
    $product_id = $info['product_id'];
    $variation_id = $info['variation_id'];
    $license_keys = explode("\n", trim($update['message']['text']));
    $added = 0;
    $duplicates = 0;
    foreach($license_keys as $license_key) {
        $license_key = trim($license_key);
        if($license_key == '') continue;
        $stmt = dbQuery("SELECT id FROM licenses WHERE license_key = ? AND product_id = ? AND variation_id = ?", [$license_key, $product_id, $variation_id]);
        if($stmt->fetch()) {
            $duplicates++;
            continue;
        }
        dbQuery("INSERT INTO licenses (product_id, variation_id, license_key, status) VALUES (?, ?, ?, 'free')", [$product_id, $variation_id, $license_key]);
        $added++;
    }
    $msg = '';
    if($added > 0) $msg .= "✅ {$added} لایسنس جدید با موفقیت ثبت شد.\n";
    if($duplicates > 0) $msg .= "⚠️ {$duplicates} لایسنس تکراری بودند و ثبت نشدند.";
    if($msg == '') $msg = 'هیچ لایسنسی ثبت نشد.';
    sendMessage($chat_id, $msg);
    // بازگشت به لیست لایسنس‌های مدل
    $stmt = dbQuery("SELECT * FROM licenses WHERE product_id = ? AND variation_id = ? ORDER BY id DESC", [$product_id, $variation_id]);
    $licenses = $stmt->fetchAll();
    $text = "🔑 لایسنس‌های این مدل:\n";
    $inline_keyboard = [];
    if($licenses) {
        foreach($licenses as $lic) {
            $status = $lic['status'] == 'free' ? 'آزاد' : 'فروخته‌شده';
            $assigned = $lic['status'] == 'assigned' ? (" | سفارش: #".$lic['assigned_to_order']) : '';
            $inline_keyboard[] = [
                ['text' => "{$lic['license_key']} | $status$assigned", 'callback_data' => 'admin_licenseview_' . $lic['id']]
            ];
            $text .= "{$lic['license_key']} | $status$assigned\n";
        }
    } else {
        $text .= "هیچ لایسنسی ثبت نشده است.";
    }
    $inline_keyboard[] = [
        ['text' => '➕ افزودن لایسنس جدید', 'callback_data' => 'admin_licenseadd_' . $product_id . '_' . $variation_id]
    ];
    $inline_keyboard[] = [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_licenses_' . $product_id] ];
    sendMessage($chat_id, $text, ['inline_keyboard'=>$inline_keyboard]);
    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
    return;
}

// هندل انتخاب گزینه متغیر خرید چیت با دکمه معمولی
if(isset($update['message']['text']) && file_exists("buy_step_{$user_id}.tmp")) {
    $buy_data = @json_decode(@file_get_contents("buy_step_{$user_id}.tmp"), true);
    if(isset($buy_data['step']) && is_numeric($buy_data['step'])) {
        $product_id = $buy_data['product_id'];
        $step = $buy_data['step'];
        $selected = $update['message']['text'];
        // دریافت متغیرهای محصول
        $vars = getProductVariationsFromApi($product_id);
        if(!$vars || !is_array($vars) || count($vars) == 0) {
            sendMessage($chat_id, 'محصول یا متغیرهای آن یافت نشد.');
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // دریافت نام محصول
        $products = getProductsFromApi();
        $product_name = '';
        foreach($products as $p) if($p['id'] == $product_id) $product_name = $p['name'];
        // برای پیام متنی، نیازی به urldecode نیست چون مستقیماً از تلگرام می‌آید
        $buy_data['selected'][] = trim($selected);
        $buy_data['step'] = $step+1;
        $attributes = $vars[0]['attributes'] ?? [];
        if($buy_data['step'] < count($attributes)) {
            $attr = $attributes[$buy_data['step']]['name'];
            $options = [];
            foreach($vars as $v) {
                $match = true;
                // مقایسه بر اساس نام ویژگی به جای اندیس
                for($i=0;$i<count($buy_data['selected']);$i++) {
                    $attr_name = $attributes[$i]['name'];
                    $found = false;
                    foreach($v['attributes'] as $va) {
                        if($va['name'] == $attr_name) {
                            // نرمال‌سازی برای مقایسه بهتر - حذف فاصله‌های اضافی و یکسان‌سازی
                            $selected_clean = trim(preg_replace('/\s+/', ' ', $buy_data['selected'][$i]));
                            $option_clean = trim(preg_replace('/\s+/', ' ', $va['option']));
                            // نرمال‌سازی کاراکترهای خاص (تبدیل + به + برای مقایسه)
                            $selected_clean = str_replace(['+', '&plus;'], '+', $selected_clean);
                            $option_clean = str_replace(['+', '&plus;'], '+', $option_clean);
                            // مقایسه با در نظر گیری کاراکترهای خاص
                            if($option_clean !== $selected_clean) {
                                $match = false;
                            }
                            $found = true;
                            break;
                        }
                    }
                    if(!$found) $match = false;
                }
                if($match) {
                    foreach($v['attributes'] as $a) {
                        if($a['name'] == $attr && !in_array($a['option'], $options)) $options[] = $a['option'];
                    }
                }
            }
            if(empty($options)) {
                sendMessage($chat_id, '⚠️ برای این انتخاب، گزینه‌ای یافت نشد. لطفاً از دکمه بازگشت استفاده کنید و دوباره تلاش کنید.');
                @unlink("buy_step_{$user_id}.tmp");
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            $reply_keyboard = [
                'keyboard' => [],
                'resize_keyboard' => true,
                'one_time_keyboard' => true
            ];
            foreach($options as $opt) {
                // نمایش مستقیم گزینه بدون urldecode چون از API مستقیماً می‌آید
                $reply_keyboard['keyboard'][] = [ ['text'=>$opt] ];
            }
            $reply_keyboard['keyboard'][] = [ ['text'=>'🔙 بازگشت'] ];
            file_put_contents("buy_step_{$user_id}.tmp", json_encode($buy_data));
            sendMessage($chat_id, "📦 $product_name\nلطفاً گزینه مورد نظر برای '$attr' را انتخاب کنید:", $reply_keyboard);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        } else {
            // مرحله آخر: پیدا کردن متغیر نهایی و نمایش قیمت
            $final_var = null;
            foreach($vars as $v) {
                $match = true;
                // مقایسه بر اساس نام ویژگی به جای اندیس
                for($i=0;$i<count($buy_data['selected']);$i++) {
                    $attr_name = $attributes[$i]['name'];
                    $found = false;
                    foreach($v['attributes'] as $va) {
                        if($va['name'] == $attr_name) {
                            // نرمال‌سازی برای مقایسه بهتر - حذف فاصله‌های اضافی و یکسان‌سازی
                            $selected_clean = trim(preg_replace('/\s+/', ' ', $buy_data['selected'][$i]));
                            $option_clean = trim(preg_replace('/\s+/', ' ', $va['option']));
                            // نرمال‌سازی کاراکترهای خاص (تبدیل + به + برای مقایسه)
                            $selected_clean = str_replace(['+', '&plus;'], '+', $selected_clean);
                            $option_clean = str_replace(['+', '&plus;'], '+', $option_clean);
                            // مقایسه با در نظر گیری کاراکترهای خاص
                            if($option_clean !== $selected_clean) {
                                $match = false;
                            }
                            $found = true;
                            break;
                        }
                    }
                    if(!$found) $match = false;
                }
                if($match) { $final_var = $v; break; }
            }
            if(!$final_var) { 
                // بررسی دقیق خطا
                $error_details = [];
                $error_details[] = "❌ متغیر انتخابی یافت نشد";
                $error_details[] = "📦 Product ID: " . ($product_id ?? 'نامشخص');
                $error_details[] = "📊 تعداد متغیرها: " . (isset($vars) && is_array($vars) ? count($vars) : 'نامشخص');
                
                if(isset($buy_data['selected']) && is_array($buy_data['selected'])) {
                    $error_details[] = "📋 انتخاب‌های کاربر: " . implode(', ', $buy_data['selected']);
                }
                
                if(isset($vars) && is_array($vars) && count($vars) > 0) {
                    $error_details[] = "\n📋 متغیرهای موجود:";
                    foreach(array_slice($vars, 0, 3) as $idx => $v) {
                        $attrs = [];
                        if(isset($v['attributes']) && is_array($v['attributes'])) {
                            foreach($v['attributes'] as $a) {
                                if(isset($a['name']) && isset($a['option'])) {
                                    $attrs[] = "{$a['name']}: {$a['option']}";
                                }
                            }
                        }
                        $error_details[] = "  " . ($idx + 1) . ". " . implode(' | ', $attrs);
                    }
                    if(count($vars) > 3) {
                        $error_details[] = "  ... و " . (count($vars) - 3) . " متغیر دیگر";
                    }
                } else {
                    $error_details[] = "\n❌ هیچ متغیری دریافت نشد";
                    $error_details[] = "📁 بررسی فایل cache: " . (file_exists(__DIR__ . "/product_vars_cache_{$product_id}.json") ? 'موجود' : 'وجود ندارد');
                }
                
                $error_msg = "⚠️ خطا در پیدا کردن متغیر:\n\n" . implode("\n", $error_details);
                sendMessage($chat_id, $error_msg);
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return; 
            }
            $price = $final_var['price'] ?? 'نامشخص';
            $variation_id = $final_var['id'] ?? 0;
            
            // بررسی تخفیف خرید مجدد
            $user_stmt = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
            $user_row = $user_stmt->fetch();
            $user_mobile = $user_row ? $user_row['mobile'] : '';
            
            $discount_info = null;
            $discounted_price = $price;
            $has_discount = false;
            
            // بررسی وجود تخفیف فعال برای این محصول/ویژگی
            if($user_mobile && strlen($user_mobile) >= 10) {
                $discount_check = getRepeatPurchaseDiscount($product_id, $variation_id);
                if($discount_check && (int)$discount_check['is_active'] == 1) {
                    try {
                        $eligibility = checkUserEligibleForDiscount($user_mobile, $product_id, $variation_id);
                        if($eligibility && isset($eligibility['eligible']) && $eligibility['eligible'] === true) {
                            $has_discount = true;
                            $discount_info = $eligibility['discount'];
                            $discounted_price = calculateDiscountedPrice($price, $discount_info['discount_percent']);
                        }
                    } catch (Exception $e) {
                        // در صورت خطا، تخفیف اعمال نمی‌شود
                        error_log("Error checking discount eligibility for user {$user_id} (mobile: {$user_mobile}, product: {$product_id}, variation: {$variation_id}): " . $e->getMessage());
                    }
                }
            }
            
            // ساخت پیام زیبا و حرفه‌ای با ایموجی
            $summary = "";
            
            // اگر تخفیف اعمال شده، پیام تبریک
            if($has_discount && $discount_info) {
                $custom_msg = '';
                $has_vip_header = false;
                $has_vip_price = false;
                
                if($discount_info['custom_message'] && trim($discount_info['custom_message']) != '') {
                    // بررسی و حذف متن‌های تکراری از پیام سفارشی
                    $custom_msg = $discount_info['custom_message'];
                    
                    // بررسی وجود "VIP MODE ACTIVATED"
                    if(preg_match('/✨👑.*?VIP.*?MODE.*?ACTIVATED.*?👑✨/is', $custom_msg)) {
                        $has_vip_header = true;
                        $custom_msg = preg_replace('/✨👑.*?VIP.*?MODE.*?ACTIVATED.*?👑✨/is', '', $custom_msg);
                    }
                    
                    // بررسی وجود "قیمت مخصوص VIP"
                    if(preg_match('/💫.*?قیمت.*?مخصوص.*?VIP.*?👇/is', $custom_msg)) {
                        $has_vip_price = true;
                        $custom_msg = preg_replace('/💫.*?قیمت.*?مخصوص.*?VIP.*?👇/is', '', $custom_msg);
                    }
                    
                    $custom_msg = preg_replace('/\n{3,}/', "\n\n", $custom_msg); // حذف خطوط خالی اضافی
                    $custom_msg = trim($custom_msg);
                }
                
                // اضافه کردن هدر VIP فقط اگر در پیام سفارشی نبود
                if(!$has_vip_header) {
                    $summary .= "✨👑 <b>VIP MODE ACTIVATED</b> 👑✨\n\n";
                }
                
                // اضافه کردن پیام سفارشی یا پیش‌فرض
                if($custom_msg) {
                    $summary .= $custom_msg . "\n\n";
                } else {
                    $summary .= "به‌خاطر سابقه خریدت، GoldenCheat همین الان یه تخفیف طلایی فوق‌ویژه برات باز کرد!\n\n";
                    $summary .= "این امتیاز مخصوص کاربرای خاصه… و تو یکی از اونایی! 💛🔥\n\n";
                }
                
                // اضافه کردن "قیمت مخصوص VIP" فقط اگر در پیام سفارشی نبود
                if(!$has_vip_price) {
                    $summary .= "💫 قیمت مخصوص VIP الان برات زده میشه 👇\n\n";
                }
                
                $summary .= "━━━━━━━━━━━━━━━━━━\n\n";
            }
            
            $summary .= "🛍️ <b>جزئیات سفارش شما</b>\n\n";
            $summary .= "📦 <b>محصول:</b> {$product_name}\n";
            $summary .= "━━━━━━━━━━━━━━━━━━\n";
            foreach($final_var['attributes'] as $a) {
                // تبدیل نام ویژگی به ایموجی مناسب
                $attr_emoji = '';
                if(strpos($a['name'], 'نوع') !== false) {
                    $attr_emoji = '⚙️';
                } elseif(strpos($a['name'], 'زمان') !== false || strpos($a['name'], 'مدت') !== false) {
                    $attr_emoji = '⏰';
                } elseif(strpos($a['name'], 'ورژن') !== false) {
                    $attr_emoji = '🔖';
                } else {
                    $attr_emoji = '📌';
                }
                $summary .= "{$attr_emoji} <b>{$a['name']}:</b> {$a['option']}\n";
            }
            $summary .= "━━━━━━━━━━━━━━━━━━\n";
            
            // نمایش قیمت با توجه به تخفیف
            if($has_discount && $discount_info) {
                $summary .= "💰 <b>قیمت اصلی:</b> <code>".number_format($price)." تومان</code>\n";
                $summary .= "🎁 <b>تخفیف ({$discount_info['discount_percent']}%):</b> <code>-".number_format($price - $discounted_price)." تومان</code>\n";
                $summary .= "━━━━━━━━━━━━━━━━━━\n";
                $summary .= "✅ <b>مبلغ قابل پرداخت (با تخفیف):</b> <code>".number_format($discounted_price)." تومان</code>\n\n";
            } else {
                $summary .= "💰 <b>مبلغ قابل پرداخت:</b> <code>".number_format($price)." تومان</code>\n\n";
            }
            
            $summary .= "💳 <b>اطلاعات پرداخت:</b>\n";
            $summary .= "━━━━━━━━━━━━━━━━━━\n";
            $summary .= "🔢 <b>شماره کارت:</b> <code>6219861907849813</code>\n";
            $summary .= "👤 <b>نام دارنده کارت:</b> مهدی دلال زاده احمدی\n\n";
            
            if($has_discount && $discount_info) {
                $summary .= "💸 <b>لطفاً مبلغ <code>".number_format($discounted_price)." تومان</code> را واریز کنید.</b>\n\n";
            }
            
            $summary .= "📸 لطفاً پس از واریز مبلغ، عکس رسید پرداخت را ارسال کنید.\n";
            $summary .= "⏳ پس از تایید پرداخت، لایسنس و آموزش برای شما ارسال خواهد شد.";
            
            // ذخیره قیمت با تخفیف در فایل
            file_put_contents("buy_step_{$user_id}.tmp", json_encode([
                'product_id'=>$product_id,
                'variation_id'=>$variation_id,
                'price'=>$price,
                'discounted_price'=>$discounted_price,
                'has_discount'=>$has_discount,
                'discount_percent'=>$has_discount ? $discount_info['discount_percent'] : 0,
                'summary'=>$summary,
                'step'=>'upload_receipt'
            ]));
            
            sendMessage($chat_id, $summary); 
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);           
            return;
        }
    }
}
// ... existing code ...

// مدیریت callback_query برای نمایش مدل‌های هر محصول پس از انتخاب محصول (در مراحل بعد اضافه می‌شود)

// ... existing code ...
        // مدیریت لایسنس‌های هر مدل پس از انتخاب مدل
        if(strpos($data, 'admin_licensemodel_') === 0 && $is_admin) {
            $parts = explode('_', str_replace('admin_licensemodel_', '', $data));
            $product_id = $parts[0];
            $variation_id = $parts[1];
            // دریافت لایسنس‌های این مدل از دیتابیس
            $stmt = dbQuery("SELECT * FROM licenses WHERE product_id = ? AND variation_id = ? ORDER BY id DESC", [$product_id, $variation_id]);
            $licenses = $stmt->fetchAll();
            $text = "🔑 لایسنس‌های این مدل:\n";
            $inline_keyboard = [];
            if($licenses) {
                foreach($licenses as $lic) {
                    $status = $lic['status'] == 'free' ? 'آزاد' : 'فروخته‌شده';
                    $assigned = $lic['status'] == 'assigned' ? (" | سفارش: #".$lic['assigned_to_order']) : '';
                    $inline_keyboard[] = [
                        ['text' => "{$lic['license_key']} | $status$assigned", 'callback_data' => 'admin_licenseview_' . $lic['id']]
                    ];
                    $text .= "{$lic['license_key']} | $status$assigned\n";
                }
            } else {
                $text .= "هیچ لایسنسی ثبت نشده است.";
            }
            $inline_keyboard[] = [
                ['text' => '➕ افزودن لایسنس جدید', 'callback_data' => 'admin_licenseadd_' . $product_id . '_' . $variation_id]
            ];
            $inline_keyboard[] = [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_licenses_' . $product_id] ];
            editMessage($chat_id, $message_id, $text, ['inline_keyboard'=>$inline_keyboard]);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // ... existing code ...

        // افزودن لایسنس جدید برای مدل انتخاب‌شده
        if(strpos($data, 'admin_licenseadd_') === 0 && $is_admin) {
            $parts = explode('_', str_replace('admin_licenseadd_', '', $data));
            $product_id = $parts[0];
            $variation_id = $parts[1];
            sendMessage($chat_id, 'کد لایسنس جدید را وارد کنید:', ["force_reply" => true]);
            file_put_contents("admin_licenseadd_{$chat_id}.tmp", json_encode(['product_id'=>$product_id, 'variation_id'=>$variation_id]));
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
// ... existing code ...

        // مشاهده جزئیات، حذف و ویرایش لایسنس (فقط برای لایسنس‌های آزاد)
        if(strpos($data, 'admin_licenseview_') === 0 && $is_admin) {
            $license_id = str_replace('admin_licenseview_', '', $data);
            $stmt = dbQuery("SELECT * FROM licenses WHERE id = ?", [$license_id]);
            $lic = $stmt->fetch();
            if(!$lic) {
                sendMessage($chat_id, 'لایسنس یافت نشد.');
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            $status = $lic['status'] == 'free' ? 'آزاد' : 'فروخته‌شده';
            $text = "🔑 جزئیات لایسنس:\nکد: {$lic['license_key']}\nوضعیت: $status";
            if($lic['status'] == 'assigned') {
                $text .= "\nسفارش: #{$lic['assigned_to_order']}";
                $text .= $lic['assigned_to_user'] ? "\nکاربر: {$lic['assigned_to_user']}" : '';
                $text .= $lic['assigned_at'] ? "\nتاریخ تخصیص: {$lic['assigned_at']}" : '';
            }
            $btns = [];
            if($lic['status'] == 'free') {
                $btns[] = [
                    ['text'=>'✏️ ویرایش','callback_data'=>'admin_licenseedit_'.$license_id],
                    ['text'=>'🗑 حذف','callback_data'=>'admin_licensedelete_'.$license_id]
                ];
            } else {
                // برای لایسنس‌های فروخته‌شده، دکمه حذف کامل از لیست
                $btns[] = [
                    ['text'=>'❌ حذف از لیست لایسنس‌ها','callback_data'=>'admin_licensepermanentdelete_'.$license_id]
                ];
            }
            $btns[] = [ ['text'=>'🔙 بازگشت','callback_data'=>'admin_licensemodel_'.$lic['product_id'].'_'.$lic['variation_id']] ];
            editMessage($chat_id, $message_id, $text, ['inline_keyboard'=>$btns]);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // حذف کامل لایسنس فروخته‌شده از لیست
        if(strpos($data, 'admin_licensepermanentdelete_') === 0 && $is_admin) {
            $license_id = str_replace('admin_licensepermanentdelete_', '', $data);
            $stmt = dbQuery("SELECT * FROM licenses WHERE id = ?", [$license_id]);
            $lic = $stmt->fetch();
            if(!$lic) {
                sendMessage($chat_id, 'لایسنس یافت نشد.');
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            if($lic['status'] != 'assigned') {
                sendMessage($chat_id, 'فقط لایسنس‌های فروخته‌شده قابل حذف کامل هستند.');
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            dbQuery("DELETE FROM licenses WHERE id = ?", [$license_id]);
            sendMessage($chat_id, '✅ لایسنس فروخته‌شده با موفقیت از لیست حذف شد.');
            // بازگشت به لیست لایسنس‌های مدل
            $stmt = dbQuery("SELECT * FROM licenses WHERE product_id = ? AND variation_id = ? ORDER BY id DESC", [$lic['product_id'], $lic['variation_id']]);
            $licenses = $stmt->fetchAll();
            $text = "🔑 لایسنس‌های این مدل:\n";
            $inline_keyboard = [];
            if($licenses) {
                foreach($licenses as $l) {
                    $status = $l['status'] == 'free' ? 'آزاد' : 'فروخته‌شده';
                    $assigned = $l['status'] == 'assigned' ? (" | سفارش: #".$l['assigned_to_order']) : '';
                    $inline_keyboard[] = [
                        ['text' => "{$l['license_key']} | $status$assigned", 'callback_data' => 'admin_licenseview_' . $l['id']]
                    ];
                    $text .= "{$l['license_key']} | $status$assigned\n";
                }
            } else {
                $text .= "هیچ لایسنسی ثبت نشده است.";
            }
            $inline_keyboard[] = [
                ['text' => '➕ افزودن لایسنس جدید', 'callback_data' => 'admin_licenseadd_' . $lic['product_id'] . '_' . $lic['variation_id']]
            ];
            $inline_keyboard[] = [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_licenses_' . $lic['product_id']] ];
            sendMessage($chat_id, $text, ['inline_keyboard'=>$inline_keyboard]);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // حذف لایسنس آزاد
        if(strpos($data, 'admin_licensedelete_') === 0 && $is_admin) {
            $license_id = str_replace('admin_licensedelete_', '', $data);
            $stmt = dbQuery("SELECT * FROM licenses WHERE id = ?", [$license_id]);
            $lic = $stmt->fetch();
            if(!$lic || $lic['status'] != 'free') {
                sendMessage($chat_id, 'فقط لایسنس‌های آزاد قابل حذف هستند.');
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            dbQuery("DELETE FROM licenses WHERE id = ?", [$license_id]);
            sendMessage($chat_id, 'لایسنس با موفقیت حذف شد.');
            // بازگشت به لیست لایسنس‌های مدل
            $stmt = dbQuery("SELECT * FROM licenses WHERE product_id = ? AND variation_id = ? ORDER BY id DESC", [$lic['product_id'], $lic['variation_id']]);
            $licenses = $stmt->fetchAll();
            $text = "🔑 لایسنس‌های این مدل:\n";
            $inline_keyboard = [];
            if($licenses) {
                foreach($licenses as $l) {
                    $status = $l['status'] == 'free' ? 'آزاد' : 'فروخته‌شده';
                    $assigned = $l['status'] == 'assigned' ? (" | سفارش: #".$l['assigned_to_order']) : '';
                    $inline_keyboard[] = [
                        ['text' => "{$l['license_key']} | $status$assigned", 'callback_data' => 'admin_licenseview_' . $l['id']]
                    ];
                    $text .= "{$l['license_key']} | $status$assigned\n";
                }
            } else {
                $text .= "هیچ لایسنسی ثبت نشده است.";
            }
            $inline_keyboard[] = [
                ['text' => '➕ افزودن لایسنس جدید', 'callback_data' => 'admin_licenseadd_' . $lic['product_id'] . '_' . $lic['variation_id']]
            ];
            $inline_keyboard[] = [ ['text' => '🔙 بازگشت', 'callback_data' => 'admin_licenses_' . $lic['product_id']] ];
            sendMessage($chat_id, $text, ['inline_keyboard'=>$inline_keyboard]);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // ویرایش لایسنس آزاد (ForceReply)
        if(strpos($data, 'admin_licenseedit_') === 0 && $is_admin) {
            $license_id = str_replace('admin_licenseedit_', '', $data);
            $stmt = dbQuery("SELECT * FROM licenses WHERE id = ?", [$license_id]);
            $lic = $stmt->fetch();
            if(!$lic || $lic['status'] != 'free') {
                sendMessage($chat_id, 'فقط لایسنس‌های آزاد قابل ویرایش هستند.');
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            sendMessage($chat_id, 'کد جدید لایسنس را وارد کنید:', ["force_reply" => true]);
            file_put_contents("admin_licenseedit_{$chat_id}.tmp", $license_id);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
        // مدیریت ForceReply ویرایش لایسنس آزاد
        if($is_admin && isset($update['message']['text']) && file_exists("admin_licenseedit_{$chat_id}.tmp")) {
            $license_id = @file_get_contents("admin_licenseedit_{$chat_id}.tmp");
            @unlink("admin_licenseedit_{$chat_id}.tmp");
            $new_key = trim($update['message']['text']);
            $stmt = dbQuery("SELECT * FROM licenses WHERE id = ?", [$license_id]);
            $lic = $stmt->fetch();
            if(!$lic || $lic['status'] != 'free') {
                sendMessage($chat_id, 'فقط لایسنس‌های آزاد قابل ویرایش هستند.');
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            // بررسی تکراری نبودن کد جدید
            $stmt2 = dbQuery("SELECT id FROM licenses WHERE license_key = ? AND product_id = ? AND variation_id = ? AND id != ?", [$new_key, $lic['product_id'], $lic['variation_id'], $license_id]);
            if($stmt2->fetch()) {
                sendMessage($chat_id, 'این کد لایسنس قبلاً ثبت شده است.');
                if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                return;
            }
            dbQuery("UPDATE licenses SET license_key = ? WHERE id = ?", [$new_key, $license_id]);
            sendMessage($chat_id, 'لایسنس با موفقیت ویرایش شد.');
            // بازگشت به جزئیات لایسنس
            $status = $lic['status'] == 'free' ? 'آزاد' : 'فروخته‌شده';
            $text = "🔑 جزئیات لایسنس:\nکد: {$new_key}\nوضعیت: $status";
            $btns = [
                [ ['text'=>'✏️ ویرایش','callback_data'=>'admin_licenseedit_'.$license_id], ['text'=>'🗑 حذف','callback_data'=>'admin_licensedelete_'.$license_id] ],
                [ ['text'=>'🔙 بازگشت','callback_data'=>'admin_licensemodel_'.$lic['product_id'].'_'.$lic['variation_id']] ]
            ];
            sendMessage($chat_id, $text, ['inline_keyboard'=>$btns]);
            if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
            return;
        }
// ... existing code ...

function deleteMessage($chat_id, $message_id) {
    $data = [
        'chat_id' => $chat_id,
        'message_id' => $message_id
    ];
    file_get_contents(API_URL . "deleteMessage?" . http_build_query($data));
}

if(isset($update['callback_query'])) {
    $chat_id = $update['callback_query']['message']['chat']['id'];
    $user_id = $update['callback_query']['from']['id'];
    $data = $update['callback_query']['data'] ?? '';
    $message_id = $update['callback_query']['message']['message_id'];
    $stmt_admin = dbQuery("SELECT telegram_id FROM admins WHERE telegram_id = ?", [$user_id]);
    $is_admin = ($user_id == ADMIN_ID) || ($stmt_admin->fetch());
    
    // هندل دکمه دریافت آموزش
    if($data == 'get_tutorial') {
        // دریافت آخرین سفارش کاربر
        $stmt = dbQuery("SELECT mobile FROM users WHERE telegram_id = ?", [$user_id]);
        if($row = $stmt->fetch()) {
            $mobile = $row['mobile'];
            $mobile_norm = normalizeMobile($mobile);
            
            // دریافت سفارش‌های کاربر از ووکامرس
            $url = "https://goldencheat.ir/wp-json/wc/v3/orders?consumer_key=" . WC_CONSUMER_KEY . "&consumer_secret=" . WC_CONSUMER_SECRET . "&billing_phone=" . urlencode($mobile_norm);
            $response = @file_get_contents($url);
            $orders = json_decode($response, true);
            
            if($orders && is_array($orders)) {
                // پیدا کردن آخرین سفارش تکمیل شده
                $last_completed_order = null;
                foreach($orders as $order) {
                    if($order['status'] == 'completed') {
                        $last_completed_order = $order;
                        break;
                    }
                }
                
                if($last_completed_order) {
                    // ارسال آموزش مربوط به محصول
                    sendProductTraining($chat_id, $last_completed_order['id'], $mobile_norm);
                    if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
                    return;
                }
            }
        }
        sendMessage($chat_id, "⚠️ متأسفانه سفارش تکمیل شده‌ای برای شما یافت نشد.");
        if(isset($loading_message_id) && $loading_message_id) deleteMessage($chat_id, $loading_message_id);
        return;
    }
}

// ... existing code ...
